<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/rows_factory.php';
require_once 'lib/gcomps_factory.php';
require_once 'lib/gcomp_geom.php';

///////////////////////////////////////////////////////////////////////////

class DummyEpfScreen extends AbstractRowsScreen
{
    const ID = 'dummy_epf';

    public static function get_media_url_str($no_internet)
    {
        return
        	MediaURL::encode(array('no_internet' => $no_internet));
    }

    ///////////////////////////////////////////////////////////////////////

    public function __construct()
    {
        parent::__construct(self::ID);
    }

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
    	return null;
    }

    public function get_rows_pane(MediaURL $media_url, &$plugin_cookies)
    {
        $defs = array();

        $rows[] = RowsFactory::vgap_row(50);
        $defs[] = GCompsFactory::label_v2(GCompGeom::place_center(-1, -1, 0, 0), 'Нет подключения к Сети Интернет', 1, '#FFAFAFA0', 60);
		$rows[] = RowsFactory::gcomps_row('single_row', $defs, null, 0, 1920, 500, 600, null, null);

        return
        	RowsFactory::pane($rows);
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        return null;
    }

    public function get_folder_view_for_epf($no_internet, &$plugin_cookies)
    {
        $media_url_str = self::get_media_url_str($no_internet);
        $media_url = MediaURL::decode($media_url_str);

        return
        	$this->get_folder_view($media_url, $plugin_cookies);
    }
}
?>
