<?php
////////////////////////////////////////////////////////////////////////////////

require_once 'lib/dune_stb_api.php';

if ($epf_dir = dirname(__FILE__))
{
	require_once "$epf_dir/config.php";
	require_once "$epf_dir/abstract_epfs_handler.php";
	require_once "$epf_dir/abstract_rows_screen.php";
	require_once "$epf_dir/dummy_epf_screen.php";
	require_once "$epf_dir/tv_rows_screen.php";
	require_once "$epf_dir/home_tv_rows_screen.php";
}

////////////////////////////////////////////////////////////////////////////////

class EpfsHandler extends AbstractEpfsHandler
{
	private static $epg;
    private static $epf_id;
    private static $data_ts_path;
    private static $tv_rows_screen;
    private static $dummy_epf_screen;
    private static $no_internet_epfs_created = false;
    private static $no_internet_epfs = array();

    ////////////////////////////////////////////////////////////////////////////

	private static function ensure_no_internet_epfs_created($first_run)
	{
		if (self::$no_internet_epfs_created)
			return;

		foreach (self::$no_internet_epfs as $epf_id)
		{
			$path = self::get_no_internet_epf_path($epf_id);

			if (!$first_run || is_file($path))
				continue;

			self::write_no_internet_epf($epf_id, self::$dummy_epf_screen->get_folder_view_for_epf(true, $plugin_cookies));
		}

		self::$no_internet_epfs_created = true;
	}

	////////////////////////////////////////////////////////////////////////////

    public static function init(Tv &$tv, EpgEngine &$epg)
    {
    	if (empty($tv) || empty($epg))
    		return;

    	self::$epg = $epg;
    	$plugin_info = get_plugin_info('embeddable_plugin_folders');
    	self::$epf_id = $plugin_info['embeddable_plugin_folders'][0]['mapping']['tv'];
    	self::$no_internet_epfs[] = self::$epf_id;
    	self::initialize($plugin_name = DuneSystem::$properties['plugin_name']);
    	self::$data_ts_path = "/config/{$plugin_name}_timestamp";

    	if (!class_exists("PluginRowsFolderView"))
    		return;

		self::$tv_rows_screen = new HomeTvRowsScreen($tv, $epg);
		self::$dummy_epf_screen = new DummyEpfScreen();

		DefaultDunePlugin::create_screen(self::$tv_rows_screen);
		DefaultDunePlugin::create_screen(self::$dummy_epf_screen);
    }

	public static function get_epf()
    {
		return json_decode(self::read_epf_data(self::$epf_id));
	}

    public static function need_update_epf_mapping()
    {
    	if (!empty(self::$tv_rows_screen))
			self::$tv_rows_screen->need_update_epf_mapping_flag = true;
	}

	public static function invalidate_folders($media_urls = null, $post_action = null)
	{
		return
			ActionFactorySafe::invalidate_folders(array_merge(array(self::$epf_id), is_array($media_urls)? $media_urls : array()), $post_action);
	}

    public static function refresh_tv_epfs(&$plugin_cookies)
    {
    	self::$epg->tv_info_set_faulty(0);
    	self::update_all_epfs(false, $plugin_cookies);
	}

    public static function update_tv_epfs(&$plugin_cookies)
    {
    	self::update_all_epfs(false, $plugin_cookies);
	}

    public static function update_all_epfs($first_run, &$plugin_cookies)
    {
    	self::ensure_no_internet_epfs_created($first_run);

        $cold_run = !is_file(self::warmed_up_path());

        try
        {
            $folder_view = self::$tv_rows_screen->get_folder_view_for_epf($plugin_cookies);
        }
        catch (Exception $e)
        {
            hd_print("Exception while generating epf: ".$e->getMessage());
            return null;
        }

		if (json_encode($folder_view) <> self::read_epf_data(self::$epf_id))
			self::write_epf_data(self::$epf_id, $folder_view);

		if ($cold_run)
			file_put_contents(self::warmed_up_path(), '');
    }
}

?>
