<?php

###############################################################################
#
# Playback Points
#
# Author: Brigadir (forum.mydune.ru)
# Date: 30-01-2021
# Latest update: 23-01-2022
#
###############################################################################

require_once 'lib/media_url.php';
require_once 'lib/dune_stb_api.php';

///////////////////////////////////////////////////////////////////////////////

class PlaybackPoints
{
	///////////////////////////////////////////////////////////////////////////

	private	static $instance;

	private $firmware_bn;
	private	$curr_point;
	private $points;
	private $tmp_path;

	///////////////////////////////////////////////////////////////////////////

    private function __construct()
    {
    	$this->tmp_path = DuneSystem::$properties['tmp_dir_path'] . '/watch_history.tmp';
		$fw = get_parsed_firmware_ver();
		$this->firmware_bn = $fw['branch_num'];
	}

	private function update_curr_point($tv_group_id)
	{
		if (isset($this->curr_point->channel_id))
		{
			$time = time();
			$this->curr_point->time = $time;
			$this->curr_point->group_id = $tv_group_id;

			if (isset($this->curr_point->archive_tm) && ($this->curr_point->archive_tm > 0))
			{
				$player_state = get_player_state_assoc();
				$time_position = max($time - $this->curr_point->time, 0);

				if (isset($player_state['playback_state']) && (($player_state['playback_state'] == PLAYBACK_PLAYING) || ($player_state['playback_state'] == PLAYBACK_STOPPED) || ($player_state['playback_state'] == PLAYBACK_PAUSED)))
					$this->curr_point->position = max((empty($player_state['playback_position']) || ($this->firmware_bn <= 9))? $this->curr_point->position + $time_position : $player_state['playback_position'], 0);
			}

			if (class_exists("PluginRowsFolderView"))
				file_put_contents($this->tmp_path, serialize(array_merge(array($this->curr_point), $this->points)));
		}
	}

	private function push_point($channel_id, $archive_ts)
	{
		$prev_point = MediaURL::decode($this->curr_point->get_raw_string());
		$this->curr_point->group_id = null;
		$this->curr_point->channel_id = $channel_id;
		$this->curr_point->archive_tm = $archive_ts;
		$this->curr_point->position = 0;
		$this->curr_point->time = PHP_INT_MAX;

		if (isset($prev_point->channel_id))
			array_unshift($this->points, $prev_point);
	}

	private function get_prev_point()
	{
		return isset($this->points[0])? $this->points[0] : null;
	}

	///////////////////////////////////////////////////////////////////////////

	public static function init()
	{
		if (is_null(self::$instance))
			self::$instance = new PlaybackPoints();

		self::$instance->points = array();
		self::$instance->curr_point = MediaURL::decode();
	}

	public static function clear()
	{
		if (file_exists(self::$instance->tmp_path))
			unlink(self::$instance->tmp_path);
	}

	public static function update($tv_group_id)
	{
		if (!is_null(self::$instance))
			if (self::$instance->firmware_bn >= 9)
				self::$instance->update_curr_point($tv_group_id);
	}

	public static function push($channel_id, $archive_ts)
	{
		if (!is_null(self::$instance))
			if (self::$instance->firmware_bn >= 9)
			{
				$player_state = get_player_state_assoc();

				if (!isset($player_state['last_playback_event']) || ($player_state['last_playback_event'] <> PLAYBACK_PCR_DISCONTINUITY))
					self::$instance->push_point($channel_id, $archive_ts);
			}
	}

	public static function get_prev()
	{
		if (!is_null(self::$instance))
			if (self::$instance->firmware_bn >= 9)
				if (!is_null($point = self::$instance->get_prev_point()))
				{
					$media_url = MediaURL::decode();
					$media_url->channel_id = $point->channel_id;
					$media_url->archive_tm = $point->archive_tm;
					$media_url->position = $point->position;
					$media_url->time = $point->time;

					return $media_url;
				}

		return null;
	}

	public static function get_all()
	{
		return
			file_exists(self::$instance->tmp_path)? unserialize(file_get_contents(self::$instance->tmp_path)) : array();
	}

	///////////////////////////////////////////////////////////////////////////

}

?>
