<?php

###############################################################################
#
# Автор (Author): Brigadir (forum.mydune.ru)
# Дата (Date): 30-12-2019
# Последнее обновление (Latest update): 30-03-2025
#
###############################################################################

abstract class DefaultEpgParser
{
	public abstract function get_parser_id();		// (char) возвращает идентификатор EPG-сервиса
	public abstract function get_parser_name();		// (char) возвращает имя EPG-сервиса
	public abstract function thumbnails_support();	// (bool) возвращает TRUE если информация о телепередачах сопровождается картинкой (или картинками), или FALSE в противном случае
	public abstract function get_future_days();		// (int) возвращает количество доступных будущих дней телепрограммы
	public abstract function get_past_days();		// (int) возвращает количество доступных прошедших дней телепрограммы

	public function clear_cache() {}	// вызывается при очистке кеша (можно использовать для инициализации своих переменных)

	public function get_day_epg_by_id($channel_id, $day_start_ts, $timeshift_hours)
	{
		hd_print("Error in class " . get_class($this) . "! Not implements of function '" . __FUNCTION__ . "'!");
		return array();
	}

	public function get_day_epg_by_url($url, $day_start_ts, $timeshift_hours)
	{
		hd_print("Error in class " . get_class($this) . "! Not implements of function '" . __FUNCTION__ . "'!");
		return array();
	}

	public function get_epg_event_by_id($channel_id, $event_id, $timeshift_hours)
	{
		return null;
	}
}

?>
