<?php

###############################################################################
#
# Автор (Author): Brigadir (forum.mydune.ru)
# Дата (Date): 30-12-2019
# Последнее обновление (Latest update): 19-02-2023
#
###############################################################################

require_once dirname(__FILE__) . '/default_epg_parser.php';

///////////////////////////////////////////////////////////////////////////////

class VsetvEpgParser extends DefaultEpgParser
{

	///////////////////////////////////////////////////////////////////////////

	const	ROOT_URL = 'http://www.vsetv.com/';
	const	JQUERY_URN = 'jquery-gs.js';
	const	SCHEDULE_URN = 'schedule.php?selected_channel=channel_%s&selected_date=day_%s&timezone=14';

	///////////////////////////////////////////////////////////////////////////

	private	$epg;

	///////////////////////////////////////////////////////////////////////////

	public function __construct(EpgEngine &$epg)
	{
		$this->epg = $epg;
	}

	public function get_parser_id()
	{
		return 'vsetv';
	}

	public function get_parser_name()
	{
		return 'ВсёТВ портал';
	}

	public function thumbnails_support()
	{
		return false;
	}

	public function get_future_days()
	{
		return max(1, (7 - date('N', $this->epg->get_day_start_ts(null, -10800))));
	}

	public function get_past_days()
	{
		return (6 + date('N', $this->epg->get_day_start_ts(null, -10800)));
	}

	public function get_day_epg_by_id($channel_id, $day_start_ts, $timeshift_hours)
	{
		if (empty($channel_id))
		{
			hd_print('Warning! Entrance $epg_channel_id can`t be empty ( ' . __FILE__ . ' line ' . __LINE__ . ')');
			return array();
		}

		$data = array();

		try
		{
			$t = microtime(true);
			$epg_date = date("Y-m-d", $day_start_ts);
			$html = iconv('WINDOWS-1251', 'UTF-8', http_get_document(sprintf(self::ROOT_URL . self::SCHEDULE_URN, $channel_id, $epg_date), null, SILENT_HTTP_REQUESTS));

			hd_print('Data successfully loaded in ' . round(microtime(true) - $t, 4) . ' sec');
		}
		catch (Exception $e)
		{
			hd_print("Can't fetch from VSETV (ID=$channel_id DATE=$epg_date)");

			return $data;
		}

		$patterns = array("/\n/", "/.*?<div class=\"clear\">.*?<div id=\"schedule_container\".*?>/", "/<div class=\"clear\">.*/", "/<div class=\"pasttime\">/", "/<div class=\"onair\">/", "/<div class=\"time\">/", "/<div class=\"pastprname\">|<div class=\"prname\">/", "/<div class=\"desc\">/", "/<br><br>/", "/<br>/", "/&nbsp;/", "/<img src=\"pic\/.*_live.*>/U");
		$replacements = array("", "", "", "\n", "\n", "\n", "|", "|", ". ", ". ", "");
		$html = preg_replace($patterns, $replacements, $html);

		if (preg_match_all('/<img src=".*">/iU', $html, $matches))
		{
			$max = -1;
			$imgs = array_flip(array_count_values($matches[0]));
			krsort($imgs);

			foreach($imgs as $cnt => $val)
			{
				if (preg_match('/_premiere|_more/i', $val))
				{
					$tags[] = $val;
					$reps[] = '';
				}
				else
				{
					$tags[] = $val;

					if ($max < 0)
					{
						$reps[] = 0;
						$max = 0;
					}
					else
						$reps[] = 5;
				}
			}
		}
		else
			$tags = $reps = array();

		$html = preg_replace_callback(
			'/[0-2][0-9]:[0-5][0-9]/',
			create_function(
				'$matches',
				'return strtotime("'.$epg_date.' $matches[0] GMT+3");'),
			strip_tags(
				str_replace($tags, $reps, $html)
			)
		);

		$program_start_ts = 0;
		$epg_items = explode("\n", trim($html, "\n"));
		$timeshift_secs = empty($timeshift_hours)? 0 : $timeshift_hours * 3600;

		foreach ($epg_items as $epg_item)
		{
			$program_items = explode('|', $epg_item);
			$program_ts = !empty($program_items[0])? explode('- ', $program_items[0]) : null;
			$start_ts = intval($program_ts[0]) + $timeshift_secs;

			if ($start_ts <= $timeshift_secs)
				continue;

			$stop_ts = empty($program_ts)? -1 : (intval($program_ts[1]) + $timeshift_secs);
			$program_start_ts = empty($program_start_ts)? $start_ts : (($start_ts < $program_start_ts)? $start_ts + 86400 : $start_ts);
			$program_stop_ts = ($stop_ts < $program_start_ts)? $stop_ts + 86400 : $stop_ts;
			$data[$program_start_ts] =
				array
				(
					ExtEpgProgram::id => '',
					ExtEpgProgram::start_tm => $program_start_ts,
					ExtEpgProgram::end_tm => $program_stop_ts,
					ExtEpgProgram::title => !empty($program_items[1])? preg_replace('/\*|"|«|»/', '', rtrim($program_items[1], '.')) : '',
					ExtEpgProgram::desc => !empty($program_items[2])? preg_replace('/\s\/\s/', '/', $program_items[2]) : '',
					ExtEpgProgram::main_category => '',
					ExtEpgProgram::main_icon => '',
				);
		}

		return $data;
	}

}

?>
