<?php

###############################################################################
#
# Автор (Author): Brigadir (forum.mydune.ru)
# Дата (Date): 30-03-2025
# Последнее обновление (Latest update): 06-04-2025
#
###############################################################################

require_once dirname(__FILE__) . '/default_epg_parser.php';

///////////////////////////////////////////////////////////////////////////////

class WinkEpgParser extends DefaultEpgParser
{
	///////////////////////////////////////////////////////////////////////////

	private	$epg;

	///////////////////////////////////////////////////////////////////////////

	public function __construct(EpgEngine &$epg)
	{
		$this->epg = $epg;
	}

	public function get_parser_id()
	{
		return 'wink';
	}

	public function get_parser_name()
	{
		return 'WINK';
	}

	public function thumbnails_support()
	{
		return true;
	}

	public function get_future_days()
	{
		return 3;
	}

	public function get_past_days()
	{
		return 3;
	}

	public function get_day_epg_by_id($channel_id, $day_start_ts, $timeshift_hours)
	{
		if (empty($channel_id))
		{
			hd_print('Warning! Entrance $epg_channel_id can`t be empty ( ' . __FILE__ . ' line ' . __LINE__ . ')');
			return array();
		}

		$data = array();

		if ($epg = Wink()->get_channel_epg($channel_id, $day_start_ts, $day_start_ts + 86400))
		{
			$timeshift_secs = empty($timeshift_hours)? 0 : $timeshift_hours * 3600;

			foreach ($epg as $event)
			{
				switch($event['genre'])
				{
					case 'Сериалы':
						$genre = 'Телесериал';
						$cine = 'Т/с ';
						break;

					case 'Фильмы':
						$genre = 'Художественный фильм';
						$cine = 'Х/ф ';
						break;

					default:
						$genre = $event['genre'];
						$cine = '';
				}

				$premier = preg_match('/^премьера(\s+года\.*)*/iu', $event['name'], $matches)? trim($matches[0], '. ') : '';
				$title = trim($premier? preg_replace('/^премьера(\s+года\.*)*/iu', '', $event['name']) : $event['name'], '., ');

				$data[$event['start_time'] + $timeshift_secs] =
					array
					(
						ExtEpgProgram::id => $event['id'],
						ExtEpgProgram::start_tm => $event['start_time'] + $timeshift_secs,
						ExtEpgProgram::end_tm => $event['end_time'] + $timeshift_secs,
						ExtEpgProgram::title => $cine . preg_replace('/^"(.+)"/uU', '$1', $title),
						ExtEpgProgram::sub_title => $premier,
						ExtEpgProgram::desc => $event['description'],
						ExtEpgProgram::main_category => trim("[" . $event['age_level'] . "] $genre"),
						ExtEpgProgram::main_icon => extract(pathinfo($event['logo']))? "$dirname/c400x300/$basename" : '',
						ExtEpgProgram::icon_urls => array(),
					);
			}

			ksort($data);
		}

		return $data;
	}
}

?>
