<?php
///////////////////////////////////////////////////////////////////////////

class ActionFactory
{
    public static function open_folder($media_url = null, $caption = null,
        $id = null, $post_action = null)
    {
        return array
        (
            GuiAction::handler_string_id => PLUGIN_OPEN_FOLDER_ACTION_ID,
            GuiAction::data =>
                array
                (
                    PluginOpenFolderActionData::media_url => $media_url,
                    PluginOpenFolderActionData::caption => $caption,
                    PluginOpenFolderActionData::id => $id,
                    PluginOpenFolderActionData::post_action => $post_action,
                ),
        );
    }

    public static function tv_play($media_url = null)
    {
        $arr = array(
            GuiAction::handler_string_id => PLUGIN_TV_PLAY_ACTION_ID,
        );

        if ($media_url)
        {
            $arr[GuiAction::params] = array(
                'selected_media_url' => $media_url);
        }
        return $arr;
    }

    public static function vod_play($vod_info = null)
    {
        return array
        (
            GuiAction::handler_string_id => PLUGIN_VOD_PLAY_ACTION_ID,
            GuiAction::data =>
                array
                (
                    PluginVodPlayActionData::vod_info => $vod_info,
                ),
        );
    }

    public static function show_error($fatal, $title,
        $msg_lines=null, $stop_playback=false, $retry_delay_ms=0)
    {
        if ($fatal)
            hd_print("Plugin fatal error.");

        return array
        (
            GuiAction::handler_string_id => PLUGIN_SHOW_ERROR_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data =>
                array
                (
                    PluginShowErrorActionData::fatal => $fatal,
                    PluginShowErrorActionData::title => $title,
                    PluginShowErrorActionData::msg_lines => $msg_lines,
                    PluginShowErrorActionData::stop_playback => $stop_playback,
                    PluginShowErrorActionData::retry_delay_ms => $retry_delay_ms,
                ),
            GuiAction::params => null,
        );
    }

    public static function fatal_error()
    {
        return self::show_error(true, null);
    }

    public static function show_dialog($title, $defs,
        $close_by_return = false, $preferred_width = 0,
        $attrs = array())
    {
        $initial_sel_ndx = isset($attrs['initial_sel_ndx']) ?
            $attrs['initial_sel_ndx'] : -1;
        $actions = isset($attrs['actions']) ? $attrs['actions'] : null;
        $timer = isset($attrs['timer']) ? $attrs['timer'] : null;
        $min_item_title_width = isset($attrs['min_item_title_width']) ?
            $attrs['min_item_title_width'] : 0;
        $max_height = isset($attrs['max_height']) ?
            $attrs['max_height'] : 0;
        $params = isset($attrs['params']) ? $attrs['params'] : null;

        return array
        (
            GuiAction::handler_string_id => SHOW_DIALOG_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data =>
                array
                (
                    ShowDialogActionData::title => $title,
                    ShowDialogActionData::defs => $defs,
                    ShowDialogActionData::close_by_return => $close_by_return,
                    ShowDialogActionData::preferred_width => $preferred_width,
                    ShowDialogActionData::min_item_title_width => $min_item_title_width,
                    ShowDialogActionData::max_height => $max_height,
                    ShowDialogActionData::initial_sel_ndx => $initial_sel_ndx,
                    ShowDialogActionData::actions => $actions,
                    ShowDialogActionData::timer => $timer,
                    ShowDialogActionData::params => $params,
                ),
            GuiAction::params => null,
        );
    }

    public static function close_dialog_and_run($post_action)
    {
        return array
        (
            GuiAction::handler_string_id => CLOSE_DIALOG_AND_RUN_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data =>
                array
                (
                    CloseDialogAndRunActionData::post_action => $post_action,
                ),
            GuiAction::params => null,
        );
    }

    public static function close_dialog()
    {
        return self::close_dialog_and_run(null);
    }

    public static function close_and_run($post_action=null)
    {
        return array
        (
            GuiAction::handler_string_id => CLOSE_AND_RUN_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data =>
                array
                (
                    CloseAndRunActionData::post_action => $post_action,
                ),
            GuiAction::params => null,
        );
    }

    public static function show_title_dialog($title, $post_action = null)
    {
        $defs = array();

//        ControlFactory::add_vgap($defs, 50);

        ControlFactory::add_custom_close_dialog_and_apply_button($defs,
            'ok', 'OK', 300, $post_action);

        return self::show_dialog($title, $defs);
    }

    public static function show_message_dialog($title, $messages, $post_action = null)
    {
        $defs = array();

        foreach ($messages as $msg)
        {
            ControlFactory::add_label($defs, null, $msg);
            ControlFactory::add_vgap($defs, -15);
        }

        ControlFactory::add_vgap($defs, 30);
        ControlFactory::add_custom_close_dialog_and_apply_button($defs,
            'ok', 'OK', 300, $post_action);

        return self::show_dialog($title, $defs);
    }

    public static function show_yes_no_dialog($title, $yes_action,
        $close_by_return = false, $messages=null, $preferred_width=0)
    {
        $defs = array();

        if (isset($messages) && count($messages) > 0)
        {
            foreach ($messages as $msg)
                ControlFactory::add_label($defs, null, $msg);
            ControlFactory::add_vgap($defs, 20);
        }

        ControlFactory::add_custom_button($defs,
            self::close_dialog_and_run($yes_action),
            'yes', null, T::key_global('yes_no_choice_yes'), 300);

        ControlFactory::add_close_dialog_button($defs,
            T::key_global('yes_no_choice_no'), 300);

        return self::show_dialog($title,
            $defs, $close_by_return, $preferred_width);
    }

    public static function status($status)
    {
        return array
        (
            GuiAction::handler_string_id => STATUS_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data =>
                array
                (
                    StatusActionData::status => $status,
                ),
            GuiAction::params => null,
        );
    }

    public static function invalidate_folders($media_urls,
        $post_action = null, $all_except = false)
    {
        return array
        (
            GuiAction::handler_string_id => PLUGIN_INVALIDATE_FOLDERS_ACTION_ID,
            GuiAction::data =>
                array
                (
                    PluginInvalidateFoldersActionData::media_urls => $media_urls,
                    PluginInvalidateFoldersActionData::post_action => $post_action,
                    PluginInvalidateFoldersActionData::all_except => $all_except,
                ),
        );
    }

    public static function invalidate_all_folders($post_action = null,
        $except_media_urls = null)
    {
        return self::invalidate_folders($except_media_urls, $post_action, true);
    }

    public static function show_popup_menu($menu_items, $sel_ndx = 0)
    {
        return array
        (
            GuiAction::handler_string_id => SHOW_POPUP_MENU_ACTION_ID,
            GuiAction::data =>
                array
                (
                    ShowPopupMenuActionData::menu_items => $menu_items,
                    ShowPopupMenuActionData::selected_menu_item_index => $sel_ndx,
                ),
        );
    }

    public static function get_menu_item($caption, $action)
    {
        return array(
            GuiMenuItemDef::caption => $caption,
            GuiMenuItemDef::action => $action);
    }

    public static function update_regular_folder($range,
        $need_refresh = false, $sel_ndx = -1)
    {
        return array
        (
            GuiAction::handler_string_id => PLUGIN_UPDATE_FOLDER_ACTION_ID,
            GuiAction::data =>
                array
                (
                    PluginUpdateFolderActionData::range => $range,
                    PluginUpdateFolderActionData::need_refresh => $need_refresh,
                    PluginUpdateFolderActionData::sel_ndx => intval($sel_ndx),
                ),
        );
    }

    public static function reset_controls($defs, $post_action = null, $initial_sel_ndx = -1)
    {
        return array
        (
             GuiAction::handler_string_id => RESET_CONTROLS_ACTION_ID,
             GuiAction::data =>
             array
             (
                ResetControlsActionData::defs => $defs,
                ResetControlsActionData::initial_sel_ndx => $initial_sel_ndx,
                ResetControlsActionData::post_action => $post_action,
             ),
        );
    }

    public static function clear_archive_cache($archive_id=null, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => PLUGIN_CLEAR_ARCHIVE_CACHE_ACTION_ID,
             GuiAction::data =>
             array
             (
                PluginClearArchiveCacheActionData::archive_id => $archive_id,
                PluginClearArchiveCacheActionData::post_action => $post_action,
             ),
        );
    }

    public static function launch_media_url_ext($url, $caption=null,
        $post_action=null, $play_in_background=false, $start_index=-1,
        $internal_player_only=false)
    {
        $arr = array
        (
             GuiAction::handler_string_id => LAUNCH_MEDIA_URL_ACTION_ID,
             GuiAction::data =>
             array
             (
                LaunchMediaUrlActionData::url => $url,
                LaunchMediaUrlActionData::caption => $caption,
                LaunchMediaUrlActionData::post_action => $post_action,
                LaunchMediaUrlActionData::play_in_background => $play_in_background,
                LaunchMediaUrlActionData::start_index => $start_index,
                LaunchMediaUrlActionData::internal_player_only => $internal_player_only,
             ),
        );
        return $arr;
    }

    public static function launch_media_url($url, $post_action=null)
    {
        return self::launch_media_url_ext($url, null, $post_action);
    }

    public static function launch_playlist($url, $start_index)
    {
        return array
        (
             GuiAction::handler_string_id => PLAYLIST_PLAY_ACTION_ID,
             GuiAction::data =>
             array
             (
                PlaylistPlayActionData::url => $url,
                PlaylistPlayActionData::start_index => $start_index,
             ),
        );
    }

    public static function launch_file($url, $caption=null)
    {
        return array
        (
             GuiAction::handler_string_id => FILE_PLAY_ACTION_ID,
             GuiAction::data =>
             array
             (
                FilePlayActionData::url => $url,
                FilePlayActionData::caption => $caption,
             ),
        );
    }

    public static function show_main_screen($post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => SHOW_MAIN_SCREEN_ACTION_ID,
             GuiAction::data =>
             array
             (
                ShowMainScreenActionData::post_action => $post_action,
             ),
        );
    }

    public static function switch_osd_mode($osd_mode=null, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => SWITCH_OSD_MODE_ACTION_ID,
             GuiAction::data =>
             array
             (
                SwitchOsdModeActionData::osd_mode => $osd_mode,
                SwitchOsdModeActionData::post_action => $post_action,
             ),
        );
    }

    public static function stop_playback($wait_for_completion=false, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => STOP_PLAYBACK_ACTION_ID,
             GuiAction::data =>
             array
             (
                StopPlaybackActionData::wait_for_completion => $wait_for_completion,
                StopPlaybackActionData::post_action => $post_action,
             ),
        );
    }

    public static function handle_user_input($params, $timeout_ms=null, $show_dialog_delay_ms=null)
    {
        $data = null;
        if (isset($timeout_ms) || isset($show_dialog_delay_ms))
        {
            $data = array();
            if (isset($timeout_ms))
            {
                $data[PluginHandleUserInputActionData::operation_timeout] =
                    intval($timeout_ms);
            }
            if (isset($show_dialog_delay_ms))
            {
                $data[PluginHandleUserInputActionData::show_dialog_delay] =
                    intval($show_dialog_delay_ms);
            }
        }

        return array
        (
            GuiAction::handler_string_id => PLUGIN_HANDLE_USER_INPUT_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data => $data,
            GuiAction::params => $params,
        );
    }

    public static function change_behaviour($actions, $timer=null, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => CHANGE_BEHAVIOUR_ACTION_ID,
             GuiAction::data =>
             array
             (
                ChangeBehaviourActionData::actions => $actions,
                ChangeBehaviourActionData::timer => $timer,
                ChangeBehaviourActionData::post_action => $post_action,
             ),
        );
    }

    public static function add_menu_items($menu_items)
    {
        return array
        (
            GuiAction::handler_string_id => ADD_MENU_ITEMS_ACTION_ID,
            GuiAction::data =>
                array
                (
                    AddMenuItemsActionData::menu_items => $menu_items,
                ),
        );
    }

    public static function rename_path($caption, $post_action = null)
    {
        return array
        (
            GuiAction::handler_string_id => RENAME_PATH_ACTION_ID,
            GuiAction::data =>
                array
                (
                    RenamePathActionData::caption => $caption,
                    RenamePathActionData::post_action => $post_action,
                ),
        );
    }

    public static function add_path_element(&$elements,
        $media_url, $caption, $id)
    {
        $elements[] = array(
            PluginPathElement::media_url => $media_url,
            PluginPathElement::caption => $caption,
            PluginPathElement::id => $id);
    }

    public static function replace_path($erase_count, $elements = null,
        $post_action = null)
    {
        return array
        (
            GuiAction::handler_string_id => PLUGIN_REPLACE_PATH_ACTION_ID,
            GuiAction::data =>
                array
                (
                    PluginReplacePathActionData::erase_count => $erase_count,
                    PluginReplacePathActionData::elements => $elements,
                    PluginReplacePathActionData::post_action => $post_action,
                ),
        );
    }

    public static function run_builtin($builtin_action_id, $params=null,
        $post_action=null, $error_action=null)
    {
        return array
        (
            GuiAction::handler_string_id => RUN_BUILTIN_ACTION_ID,
            GuiAction::data =>
                array
                (
                    RunBuiltinActionData::builtin_action_id => $builtin_action_id,
                    RunBuiltinActionData::params => $params,
                    RunBuiltinActionData::post_action => $post_action,
                    RunBuiltinActionData::error_action => $error_action,
                ),
        );
    }

    public static function change_settings($settings,
        $reboot, $restart_gui, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => CHANGE_SETTINGS_ACTION_ID,
             GuiAction::data =>
             array
             (
                ChangeSettingsActionData::settings => $settings,
                ChangeSettingsActionData::reboot => $reboot,
                ChangeSettingsActionData::restart_gui => $restart_gui,
                ChangeSettingsActionData::post_action => $post_action,
             ),
        );
    }

    public static function clear_watch_history($item_ids=null, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => CLEAR_WATCH_HISTORY_ACTION_ID,
             GuiAction::data =>
             array
             (
                ClearWatchHistoryActionData::item_ids => $item_ids,
                ClearWatchHistoryActionData::post_action => $post_action,
             ),
        );
    }

    public static function check_system_storage($required_space, $recommended_space,
        $title, $messages, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => CHECK_SYSTEM_STORAGE_ACTION_ID,
             GuiAction::data =>
             array
             (
                CheckSystemStorageActionData::required_space => $required_space,
                CheckSystemStorageActionData::recommended_space => $recommended_space,
                CheckSystemStorageActionData::messages => $messages,
                CheckSystemStorageActionData::post_action => $post_action,
             ),
        );
    }

    public static function init_persistfs($post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => INIT_PERSISTFS_ACTION_ID,
             GuiAction::data =>
             array
             (
                CheckSystemStorageActionData::post_action => $post_action,
             ),
        );
    }

    public static function wait_ext_app_start(
        $delay, $package, $error_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => WAIT_EXT_APP_START_ACTION_ID,
             GuiAction::data =>
             array
             (
                WaitExtAppStartActionData::delay => $delay,
                WaitExtAppStartActionData::package => $package,
                WaitExtAppStartActionData::error_action => $error_action,
             ),
        );
    }

    public static function launch_ext_app(
        $cmd, $ensure_playback_stopped, $delay, $package,
        $error_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => LAUNCH_EXT_APP_ACTION_ID,
             GuiAction::data =>
             array
             (
                LaunchExtAppActionData::cmd => $cmd,
                LaunchExtAppActionData::ensure_playback_stopped => $ensure_playback_stopped,
                LaunchExtAppActionData::delay => $delay,
                LaunchExtAppActionData::package => $package,
                LaunchExtAppActionData::error_action => $error_action,
             ),
        );
    }

    public static function download_and_install_apk(
        $caption, $package, $urls, $indirect=false, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => DOWNLOAD_AND_INSTALL_APK_ACTION_ID,
             GuiAction::data =>
             array
             (
                DownloadAndInstallApkActionData::caption => $caption,
                DownloadAndInstallApkActionData::package => $package,
                DownloadAndInstallApkActionData::urls => $urls,
                DownloadAndInstallApkActionData::indirect => $indirect,
                DownloadAndInstallApkActionData::post_action => $post_action,
             ),
        );
    }

    public static function add_to_favorites(
        $media_url, $caption=null, $icon_url=null,
        $skip_interactions, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => ADD_TO_FAVORITES_ACTION_ID,
             GuiAction::data =>
             array
             (
                AddToFavoritesActionData::media_url => $media_url,
                AddToFavoritesActionData::caption => $caption,
                AddToFavoritesActionData::icon_url => $icon_url,
                AddToFavoritesActionData::skip_interactions => $skip_interactions,
                AddToFavoritesActionData::post_action => $post_action,
             ),
        );
    }

    public static function remove_from_favorites(
        $name, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => REMOVE_FROM_FAVORITES_ACTION_ID,
             GuiAction::data =>
             array
             (
                RemoveFromFavoritesActionData::name => $name,
                RemoveFromFavoritesActionData::post_action => $post_action,
             ),
        );
    }

    public static function timer($delay_ms,
        $reset_on_keypress=false, $clear_on_keypress=false)
    {
        $arr = array(GuiTimerDef::delay_ms => $delay_ms);
        if ($reset_on_keypress)
            $arr[GuiTimerDef::reset_on_keypress] = true;
        if ($clear_on_keypress)
            $arr[GuiTimerDef::clear_on_keypress] = true;
        return $arr;
    }

    public static function change_gcomps($gcomps_screen,
        $change_defs, $interrupt_disabled=false, $num_steps=0,
        $small_state_text=null,
        $post_action=null, $ui_state=null)
    {
        $sel_state = $gcomps_screen->get_cur_sel_state_str();

        return array(
            GuiAction::handler_string_id => CHANGE_GCOMPS_ACTION_ID,
            GuiAction::data => array(
                ChangeGCompsActionData::change_defs => $change_defs,
                ChangeGCompsActionData::interrupt_disabled => $interrupt_disabled,
                ChangeGCompsActionData::num_steps => $num_steps,
                ChangeGCompsActionData::sel_state => $sel_state,
                ChangeGCompsActionData::small_state_text => $small_state_text,
                ChangeGCompsActionData::ui_state => $ui_state,
                ChangeGCompsActionData::post_action => $post_action,
            ));
    }

    public static function update_rows_info(
        $folder_key, $item_id, $info_defs,
        $bg_url=null, $nl_bg_url=null, $mask_url=null,
        $playback_urls=null, $post_action=null)
    {
        $info = array(
            PluginRowsInfo::folder_key => $folder_key,
            PluginRowsInfo::item_id => $item_id,
            PluginRowsInfo::info_defs => $info_defs,
            PluginRowsInfo::bg_url => $bg_url,
            PluginRowsInfo::nl_bg_url => $nl_bg_url,
            PluginRowsInfo::mask_url => $mask_url,
            PluginRowsInfo::playback_urls => $playback_urls,
        );
        return array
        (
             GuiAction::handler_string_id => PLUGIN_UPDATE_ROWS_INFO_ACTION_ID,
             GuiAction::data =>
             array
             (
                PluginUpdateRowsInfoActionData::info => $info,
                PluginUpdateRowsInfoActionData::post_action => $post_action,
             ),
        );
    }

    public static function clear_rows_info_cache($post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => PLUGIN_UPDATE_ROWS_INFO_ACTION_ID,
             GuiAction::data =>
             array
             (
                PluginUpdateRowsInfoActionData::clear_cache => true,
                PluginUpdateRowsInfoActionData::post_action => $post_action,
             ),
        );
    }

    ///////////////////////////////////////////////////////////////////////

    // A bit hacky.
    public static function set_post_action($action, $post_action)
    {
        if (!isset($post_action))
            return $action;
        if (!isset($action))
            return $post_action;

        $a = &$action;
        for (;;)
        {
            if (!isset($a['data']['post_action']))
            {
                $a['data']['post_action'] = $post_action;
                break;
            }
            else
                $a = &$a['data']['post_action'];
        }

        return $action;
    }

    public static function update_epf_mapping(
        $epf_id, $mapped_plugin_name, $post_action = null)
    {
        return array
        (
             GuiAction::handler_string_id => PLUGIN_UPDATE_EPF_MAPPING_ACTION_ID,
             GuiAction::data =>
             array
             (
                PluginUpdateEpfMappingActionData::epf_id => $epf_id,
                PluginUpdateEpfMappingActionData::mapped_plugin_name => $mapped_plugin_name,
                PluginUpdateEpfMappingActionData::post_action => $post_action,
             ),
        );
    }

    public static function refresh_entry_points($post_action = null)
    {
        return array
        (
             GuiAction::handler_string_id => PLUGIN_REFRESH_ENTRY_POINTS_ACTION_ID,
             GuiAction::data =>
             array
             (
                PluginRefreshEntryPointsActionData::post_action => $post_action,
             ),
        );
    }

    public static function wget($url, $post_data=null, $curl_opts=null, $id=null, $target_path=null, $result_key_prefix=null, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => WGET_ACTION_ID,
             GuiAction::data =>
             array
             (
                WgetActionData::id => $id,
                WgetActionData::url => $url,
                WgetActionData::post_data => $post_data,
                WgetActionData::curl_opts => $curl_opts,
                WgetActionData::target_path => $target_path,
                WgetActionData::result_key_prefix => $result_key_prefix,
                WgetActionData::post_action => $post_action,
             ),
        );
    }
}

///////////////////////////////////////////////////////////////////////////
?>
