<?php

###############################################################################
#
# Useful class for working with cache files
#
# Author: Brigadir (forum.mydune.ru)
# Email: brigadir@mydune.ru
# Date: 30-01-2016
# Latest update: 07-01-2019
#
###############################################################################

class Cache
{
	// Возвращает имя самого свежего файла в каталоге $path
	public static function get_latest_file($path) {

		if (!empty($path)) {
			clearstatcache();
			if (file_exists($path)) {
				$fdate = 0;
				$fname = false;
				$files = scandir($path);
				if (!empty($files)) {
					foreach ($files as $file) {
						if (is_dir("$path/$file")) continue;
							$ifname = filemtime("$path/$file");
							if ($ifname > $fdate) {
								$fdate = $ifname;
								$fname = $file;
							}
					}
					return $fname;
				}
			}
		}
		return false;
	}

	// Чистит каталог $path за исключением $exclude_file
	public static function clean_dir($path, $exclude_file = null) {
		$path = rtrim($path, '/') . '/';
		if ($files = scandir($path)) {
			foreach ($files as $file) {
				if (is_dir($file)) continue;
				if ($file == $exclude_file) continue;
				unlink($path . $file);
			}
		}
	}

}
?>
