<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/action_factory.php';

class ControlFactory
{
	public static function add_vgap(&$defs, $vgap)
	{
		$defs[] = array
		(
			GuiControlDef::kind => GUI_CONTROL_VGAP,
			GuiControlDef::specific_def =>
				array
				(
					GuiVGapDef::vgap => $vgap
				),
		);
	}

	public static function add_label(&$defs, $title, $text, $gui_params = null)
	{
		$defs[] = array
		(
			GuiControlDef::name => '',
			GuiControlDef::title => $title,
			GuiControlDef::kind => GUI_CONTROL_LABEL,
			GuiControlDef::specific_def => array(GuiLabelDef::caption => $text),
			GuiControlDef::params => $gui_params,
		);
	}

	public static function add_smart_label(&$defs, $title, $text)
	{
		self::add_label($defs, $title, $text, array('smart' => true));
	}

	public static function add_multiline_label(&$defs, $title, $text, $num_lines)
	{
		self::add_label($defs, $title, $text, array('smart' => false, 'max_lines' => $num_lines));
	}

	public static function add_button(&$defs, $handler, $add_params, $name, $title, $caption, $width, $caption_centered = 1)
	{

		$push_action = UserInputHandlerRegistry::create_action($handler, $name, $add_params);
		$push_action['params']['action_type'] = 'apply';

		$defs[] = array
		(
			GuiControlDef::name => $name,
			GuiControlDef::title => $title,
			GuiControlDef::kind => GUI_CONTROL_BUTTON,
			GuiControlDef::params =>array('button_caption_centered' => $caption_centered),
			GuiControlDef::specific_def =>
				array
				(
					GuiButtonDef::caption => $caption,
					GuiButtonDef::width => $width,
					GuiButtonDef::push_action => $push_action,
				),
		);
	}

	public static function add_custom_button(&$defs, $push_action, $name, $title,
		$caption, $width, $caption_centered = 1, $smart_style = false, $height = -1) {

		$push_action['params']['action_type'] = 'apply';

		$params['button_caption_centered'] = $caption_centered;
		if ($smart_style) $params['button_style'] = 'smart_label';
		if ($height > 0) $params['button_height'] = $height;

		$defs[] = array
		(
			GuiControlDef::name => $name,
			GuiControlDef::title => $title,
			GuiControlDef::kind => GUI_CONTROL_BUTTON,
			GuiControlDef::params => $params,
			GuiControlDef::specific_def => array
			(
				GuiButtonDef::caption => $caption,
				GuiButtonDef::width => $width,
				GuiButtonDef::push_action => $push_action,
			),
		);
	}

	public static function add_close_dialog_button(&$defs, $caption, $width, $caption_centered = 1) {
		$defs[] = array
		(
			GuiControlDef::name => 'close',
			GuiControlDef::title => null,
			GuiControlDef::kind => GUI_CONTROL_BUTTON,
			GuiControlDef::params =>array('button_caption_centered' => $caption_centered),
			GuiControlDef::specific_def =>
				array
				(
					GuiButtonDef::caption => $caption,
					GuiButtonDef::width => $width,
					GuiButtonDef::push_action =>
						ActionFactorySafe::close_dialog(),
				),
		);
	}

	public static function add_close_dialog_and_apply_button(&$defs, $handler, $add_params,
		$name, $caption, $width, $caption_centered = 1) {

		$push_action = UserInputHandlerRegistry::create_action(
			$handler, $name, $add_params);
		$push_action['params']['action_type'] = 'apply';

		$defs[] = array
		(
			GuiControlDef::name => $name,
			GuiControlDef::title => null,
			GuiControlDef::kind => GUI_CONTROL_BUTTON,
			GuiControlDef::params =>array('button_caption_centered' => $caption_centered),
			GuiControlDef::specific_def =>
				array
				(
					GuiButtonDef::caption => $caption,
					GuiButtonDef::width => $width,
					GuiButtonDef::push_action =>
						ActionFactorySafe::close_dialog_and_run($push_action),
				),
		);
	}

	public static function add_custom_close_dialog_and_apply_button(&$defs,
		$title, $caption, $width, $action = null, $caption_centered = 1) {

		$defs[] = array
		(
			GuiControlDef::name => '',
			GuiControlDef::title => $title,
			GuiControlDef::kind => GUI_CONTROL_BUTTON,
			GuiControlDef::params =>array('button_caption_centered' => $caption_centered),
			GuiControlDef::specific_def =>
				array
				(
					GuiButtonDef::caption => $caption,
					GuiButtonDef::width => $width,
					GuiButtonDef::push_action =>
						ActionFactorySafe::close_dialog_and_run($action),
				),
		);
	}

    public static function add_text_field(&$defs,
        $handler, $add_params,
        $name, $title, $initial_value,
        $numeric, $password, $has_osk, $always_active, $width,
        $need_confirm = false, $need_apply = false, $gui_params = null /* array('fixed_osk_id' => 'numeric') */)
    {
        $apply_action = null;
        if ($need_apply)
        {
            $apply_action = UserInputHandlerRegistry::create_action(
                $handler, $name, $add_params);
            $apply_action['params']['action_type'] = 'apply';
        }

        $confirm_action = null;
        if ($need_confirm)
        {
            $confirm_action = UserInputHandlerRegistry::create_action(
                $handler, $name, $add_params);
            $confirm_action['params']['action_type'] = 'confirm';
        }

        $defs[] = array
        (
            GuiControlDef::name => $name,
            GuiControlDef::title => $title,
            GuiControlDef::kind => GUI_CONTROL_TEXT_FIELD,
            GuiControlDef::specific_def =>
                array
                (
                    GuiTextFieldDef::initial_value => strval($initial_value),
                    GuiTextFieldDef::numeric => intval($numeric),
                    GuiTextFieldDef::password => intval($password),
                    GuiTextFieldDef::has_osk => intval($has_osk),
                    GuiTextFieldDef::always_active => intval($always_active),
                    GuiTextFieldDef::width => intval($width),
                    GuiTextFieldDef::apply_action => $apply_action,
                    GuiTextFieldDef::confirm_action => $confirm_action,
                ),
            GuiControlDef::params => $gui_params,
        );
    }

    public static function add_combobox(&$defs,
        $handler, $add_params,
        $name, $title, $initial_value, $value_caption_pairs, $width,
        $need_confirm = false, $need_apply = false, $gui_params = null)
    {
        $apply_action = null;
        if ($need_apply)
        {
            $apply_action = UserInputHandlerRegistry::create_action(
                $handler, $name, $add_params);
            $apply_action['params']['action_type'] = 'apply';
        }

        $confirm_action = null;
        if ($need_confirm)
        {
            $confirm_action = UserInputHandlerRegistry::create_action(
                $handler, $name, $add_params);
            $confirm_action['params']['action_type'] = 'confirm';
        }

        $defs[] = array
        (
            GuiControlDef::name => $name,
            GuiControlDef::title => $title,
            GuiControlDef::kind => GUI_CONTROL_COMBOBOX,
            GuiControlDef::specific_def =>
                array
                (
                    GuiComboboxDef::initial_value => $initial_value,
                    GuiComboboxDef::value_caption_pairs => $value_caption_pairs,
                    GuiComboboxDef::width => $width,
                    GuiComboboxDef::apply_action => $apply_action,
                    GuiComboboxDef::confirm_action => $confirm_action,
                ),
            GuiControlDef::params => $gui_params,
        );
    }

}

///////////////////////////////////////////////////////////////////////////
?>
