<?php
///////////////////////////////////////////////////////////////////////////

class MediaURL
{
    private $map;

    ///////////////////////////////////////////////////////////////////////

    private function __construct($url)
    {
		if (is_object($url))
			$this->map = $url;
		else if ($url <> '')
		{
			if (is_array($url))
				$this->map = json_decode(json_encode($url));
			else if (substr((string)$url, 0, 1) !== '{')
				$this->map = (object) array('screen_id' => $url);
			else $this->map = json_decode($url);
		}
    }

    ///////////////////////////////////////////////////////////////////////////

    public function __set($key, $value)
    {
        if (is_null($this->map))
            $this->map = (object) array();

        $this->map->{$key} = $value;
    }

    public function __unset($key)
    {
        if (isset($this->map->{$key}))
        	unset($this->map->{$key});
    }

    public function __get($key)
    {
        if (is_null($this->map))
            return null;

        return
        	isset($this->map->{$key}) ? $this->map->{$key} : null;
    }

    public function __isset($key)
    {
		if (is_null($this->map))
			return false;

		return isset($this->map->{$key});
    }

    public function get_raw_string()
    {
    	return is_object($this->map)? json_encode($this->map) : '';
    }

    ///////////////////////////////////////////////////////////////////////////

    public static function encode($m)
    {
		return json_encode($m);
    }


    public static function decode($url = '')
    {
		return new MediaURL($url);
    }
}

///////////////////////////////////////////////////////////////////////////
?>
