<?php

class RowsFactory
{
    public static function pane($rows, $focus=null, $bg=null,
        $header_enabled=false, $single_list_navigation=false,
        $initial_focus_header=-1,
        $initial_focus_item_id=null, $initial_focus_row_id=null,
        $hfactor=1.0, $hend_min_offset=0,
        $vfactor=1.0, $vgravity=0.0, $vend_min_offset=0)
    {
        if (!$focus)
            $focus = self::focus();
        return array(
            PluginRowsPane::rows => $rows,
            PluginRowsPane::focus => $focus,
            PluginRowsPane::bg => $bg,
            PluginRowsPane::header_enabled => $header_enabled,
            PluginRowsPane::single_list_navigation => $single_list_navigation,
            PluginRowsPane::initial_focus_header => $initial_focus_header,
            PluginRowsPane::initial_focus_item_id => $initial_focus_item_id,
            PluginRowsPane::initial_focus_row_id => $initial_focus_row_id,
            PluginRowsPane::horizontal_focus_freedom_factor => $hfactor,
            PluginRowsPane::horizontal_focus_end_min_offset => $hend_min_offset,
            PluginRowsPane::vertical_focus_freedom_factor => $vfactor,
            PluginRowsPane::vertical_focus_gravity => $vgravity,
            PluginRowsPane::vertical_focus_end_min_offset => $vend_min_offset,
        );
    }

    public static function pane_set_geometry(&$pane,
        $w, $h, $x, $y, $y2 = 0, $min_row_index_for_y2=0,
        $info_w=0, $info_h=0, $info_x=0, $info_y=0,
        $vod_w=0, $vod_h=0, $up_arrow_dy=null)
    {
        $pane[PluginRowsPane::screen_r] = array(
            'w' => $w, 'h' => $h, 'x' => $x, 'y' => $y);
        $pane[PluginRowsPane::screen_y2] = $y2;
        $pane[PluginRowsPane::min_row_index_for_y2] = $min_row_index_for_y2;
        $pane[PluginRowsPane::info_r] = array(
            'w' => $info_w, 'h' => $info_h, 'x' => $info_x, 'y' => $info_y);
        $pane[PluginRowsPane::vod_r] = array(
            'w' => $vod_w, 'h' => $vod_h, 'x' => $w - $vod_w, 'y' => 0);
        if (isset($up_arrow_dy))
            $pane[PluginRowsPane::up_arrow_dy] = $up_arrow_dy;
    }

    public static function focus($focus_type = GCOMP_FOCUS_SYSTEM, $focus2_type = GCOMP_FOCUS_NONE)
    {
        return
        	array
        	(
            	GCompFocusDef::type => $focus_type,
            	GCompFocusDef::type2 => $focus2_type,
            );
    }

    public static function vgap_row($height, $inactive_height = -1, $id = null)
    {
        $arr = array(
            PluginRow::type => PLUGIN_ROW_TYPE_VGAP,
            PluginRow::height => $height);
        if ($inactive_height != -1)
            $arr[PluginRow::inactive_height] = $inactive_height;
        if ($id)
            $arr[PluginRow::id] = $id;

        return $arr;
    }

    public static function gcomps_row($id, $gcomp_defs, $title=null,
        $ui_level=0, $width=-1, $height=-1, $inactive_height=-1, $focusable=null,
        $ui_state=null)
    {
        return array(
            PluginRow::type => PLUGIN_ROW_TYPE_GCOMPS,
            PluginRow::id => $id,
            PluginRow::title => $title,
            PluginRow::ui_level => $ui_level,
            PluginRow::height => $height,
            PluginRow::inactive_height => $inactive_height,
            PluginRow::focusable => $focusable,
            PluginRow::data => array(
                PluginGCompsRow::defs => $gcomp_defs,
                PluginGCompsRow::ui_state => $ui_state,
                PluginGCompsRow::width => $width,
            ));
    }

    public static function title_row($id, $caption,
        $group_id=null, $width=null, $height=null,
        $color=null, $font_size=null,
        $left=null, $dy=null, $active_dy=null,
        $fade_enabled=false, $fade_color=null, $lite_fade_color=null)
    {
        return array(
            PluginRow::type => PLUGIN_ROW_TYPE_TITLE,
            PluginRow::id => $id,
            PluginRow::group_id => $group_id,
            PluginRow::height => $height,
            PluginRow::inactive_height => 0,
            PluginRow::data => array(
                PluginTitleRow::caption => $caption,
                PluginTitleRow::color => $color,
                PluginTitleRow::font_size => $font_size,
                PluginTitleRow::left => $left,
                PluginTitleRow::dy => $dy,
                PluginTitleRow::active_dy => $active_dy,
                PluginTitleRow::width => $width,
                PluginTitleRow::fade_enabled => $fade_enabled,
                PluginTitleRow::fade_color => $fade_color,
                PluginTitleRow::lite_fade_color => $lite_fade_color,
            ));
    }

    public static function set_item_params_template(&$pane, $id, $params)
    {
        $pane[PluginRowsPane::regular_item_params_templates][$id] = $params;
    }

    public static function regular_row($id, $items,
        $params_template_id=null, $params=null, $title=null,
        $group_id=null, $width=null, $height=null, $inactive_height=null,
        $left_padding=null, $inactive_left_padding, $right_padding=null,
        $hide_captions=null, $hide_icons=null,
        $fade_enabled=null, $focusable=null, $show_all_action=null,
        $fade_icon_mix_color=null,
        $fade_icon_mix_alpha=null,
        $lite_fade_icon_mix_alpha=null,
        $fade_caption_color=null)
    {
        $data = array(
            PluginRegularRow::items => $items);
        if (isset($params_template_id))
            $data[PluginRegularRow::item_params_template_id] = $params_template_id;
        if (isset($params))
            $data[PluginRegularRow::item_params] = $params;
        if (isset($width))
            $data[PluginRegularRow::width] = $width;
        if (isset($left_padding))
            $data[PluginRegularRow::left_padding] = $left_padding;
        if (isset($inactive_left_padding))
            $data[PluginRegularRow::inactive_left_padding] = $inactive_left_padding;
        if (isset($right_padding))
            $data[PluginRegularRow::right_padding] = $right_padding;
        if (isset($hide_captions))
            $data[PluginRegularRow::hide_captions] = $hide_captions;
        if (isset($hide_icons))
            $data[PluginRegularRow::hide_icons] = $hide_icons;
        if (isset($fade_enabled))
            $data[PluginRegularRow::fade_enabled] = $fade_enabled;
        if (isset($fade_icon_mix_color))
            $data[PluginRegularRow::fade_icon_mix_color] = $fade_icon_mix_color;
        if (isset($fade_icon_mix_alpha))
            $data[PluginRegularRow::fade_icon_mix_alpha] = $fade_icon_mix_alpha;
        if (isset($lite_fade_icon_mix_alpha))
            $data[PluginRegularRow::lite_fade_icon_mix_alpha] = $lite_fade_icon_mix_alpha;
        if (isset($fade_caption_color))
            $data[PluginRegularRow::fade_caption_color] = $fade_caption_color;

        $arr = array(
            PluginRow::type => PLUGIN_ROW_TYPE_REGULAR,
            PluginRow::id => $id,
            PluginRow::data => $data);
        if (isset($title))
            $arr[PluginRow::title] = $title;
        if (isset($group_id))
            $arr[PluginRow::group_id] = $group_id;
        if (isset($height))
            $arr[PluginRow::height] = $height;
        if (isset($inactive_height))
            $arr[PluginRow::inactive_height] = $inactive_height;
        if (isset($focusable))
            $arr[PluginRow::focusable] = $focusable;
        if ($show_all_action)
            $arr[PluginRow::show_all_action] = $show_all_action;
        return $arr;
    }

    public static function add_regular_item(&$items,
        $id, $icon_url, $caption=null, $stickers = null)
    {
        $arr = array(
            PluginRegularItem::id => $id,
            PluginRegularItem::icon_url => $icon_url);
        if (isset($caption))
            $arr[PluginRegularItem::caption] = $caption;
        if (isset($stickers))
            $arr[PluginRegularItem::stickers] = $stickers;
        $items[] = $arr;
    }

    public static function variable_params($width, $height, $dx=null,
        $icon_width=null, $icon_height=null, $icon_dy=null,
        $caption_dy=null, $caption_color=null, $caption_font_size=null,
        $sticker_width=null, $sticker_height=null)
    {
        $arr = array(
            PluginRegularItemVariableParams::width => $width,
            PluginRegularItemVariableParams::height => $height);
        if (isset($dx))
            $arr[PluginRegularItemVariableParams::dx] = $dx;
        if (isset($icon_width))
            $arr[PluginRegularItemVariableParams::icon_width] = $icon_width;
        if (isset($icon_height))
            $arr[PluginRegularItemVariableParams::icon_height] = $icon_height;
        if (isset($icon_dy))
            $arr[PluginRegularItemVariableParams::icon_dy] = $icon_dy;
        if (isset($caption_dy))
            $arr[PluginRegularItemVariableParams::caption_dy] = $caption_dy;
        if (isset($caption_color))
            $arr[PluginRegularItemVariableParams::caption_color] = $caption_color;
        if (isset($caption_font_size))
            $arr[PluginRegularItemVariableParams::caption_font_size] = $caption_font_size;
        if (isset($sticker_width))
            $arr[PluginRegularItemVariableParams::sticker_width] = $sticker_width;
        if (isset($sticker_height))
            $arr[PluginRegularItemVariableParams::sticker_height] = $sticker_height;
        return $arr;
    }

    public static function margins($l, $t, $r, $b)
    {
        return array(
            PluginMargins::left => $l,
            PluginMargins::top => $t,
            PluginMargins::right => $r,
            PluginMargins::bottom => $b);
    }

    public static function item_params($def, $sel=null, $inactive=null,
        $loading_url=null, $load_failed_url=null,
        $hide_captions=null,
        $caption_max_num_lines=null, $caption_line_spacing=null,
        $sticker_text_size=null, $sticker_text_color=null,
        $mix_color=null, $sel_margins=null)
    {
        $arr = array(
            PluginRegularItemParams::def => $def);
        if (isset($sel))
            $arr[PluginRegularItemParams::sel] = $sel;
        if (isset($inactive))
            $arr[PluginRegularItemParams::inactive] = $inactive;
        if (isset($loading_url))
            $arr[PluginRegularItemParams::loading_url] = $loading_url;
        if (isset($load_failed_url))
            $arr[PluginRegularItemParams::load_failed_url] = $load_failed_url;
        if (isset($hide_captions))
            $arr[PluginRegularItemParams::hide_captions] = $hide_captions;
        if (isset($caption_max_num_lines))
            $arr[PluginRegularItemParams::caption_max_num_lines] = $caption_max_num_lines;
        if (isset($caption_line_spacing))
            $arr[PluginRegularItemParams::caption_line_spacing] = $caption_line_spacing;
        if ($sticker_text_size)
            $arr[PluginRegularItemParams::sticker_text_size] = $sticker_text_size;
        if (isset($sticker_text_color))
            $arr[PluginRegularItemParams::sticker_text_color] = $sticker_text_color;
        if (isset($sel_margins))
            $arr[PluginRegularItemParams::sel_margins] = $sel_margins;
        return $arr;
    }

    public static function r($x, $y, $w, $h)
    {
        return array('w' => $w, 'h' => $h, 'x' => $x, 'y' => $y);
    }

    public static function add_regular_sticker_image(&$stickers, $icon_url, $r)
    {
        $stickers[] = array(
            PluginRegularSticker::r => $r,
            PluginRegularSticker::icon_url => $icon_url);
    }

    public static function add_regular_sticker_text(&$stickers, $text, $r)
    {
        $stickers[] = array(
            PluginRegularSticker::r => $r,
            PluginRegularSticker::text => $text);
    }

    public static function add_regular_sticker_rect(&$stickers, $color, $r)
    {
        $stickers[] = array(
            PluginRegularSticker::r => $r,
            PluginRegularSticker::color => $color);
    }
}

?>
