<?php
///////////////////////////////////////////////////////////////////////////

require_once('lib/user_input_handler.php');

class UserInputHandlerRegistry
{
    private static $instance = null;

    public static function get_instance()
    {
        if (is_null(self::$instance))
            self::$instance = new UserInputHandlerRegistry();
        return self::$instance;
    }

    public static function create_action(UserInputHandler $handler, $name, $add_params = null, $timeout_ms = 60000, $show_dialog_delay_ms = 20000)
    {
        $params = array(
            'handler_id' => $handler->get_handler_id(),
            'control_id' => $name);

        if (isset($add_params))
            $params = array_merge($params, $add_params);

        $params['handler_id'] = $handler->get_handler_id();
        $params['control_id'] = $name;

        $data = null;

        if (defined('PluginHandleUserInputActionData'))
	        if (isset($timeout_ms) || isset($show_dialog_delay_ms))
	        {
	            if (isset($timeout_ms))
	                $data[PluginHandleUserInputActionData::operation_timeout] = intval($timeout_ms);

	            if (isset($show_dialog_delay_ms))
	                $data[PluginHandleUserInputActionData::show_dialog_delay] = intval($show_dialog_delay_ms);
	        }

        return
	        array
	        (
	            GuiAction::handler_string_id => PLUGIN_HANDLE_USER_INPUT_ACTION_ID,
	            GuiAction::caption => null,
	            GuiAction::data => $data,
	            GuiAction::params => $params,
	        );
    }

    ///////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////

    private $handlers;

    private function __construct()
    {
        $this->handlers = array();
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
    	if (!isset($user_input->handler_id))
            return null;

        $handler_id = $user_input->handler_id;
        if (!isset($this->handlers[$handler_id]))
            return null;

        return $this->handlers[$handler_id]->handle_user_input(
            $user_input, $plugin_cookies);
    }

    public function register_handler(UserInputHandler $handler)
    {
        $handler_id = $handler->get_handler_id();
        $this->handlers[$handler_id] = $handler;
    }
}

///////////////////////////////////////////////////////////////////////////
?>
