<?php

class Sorter implements UserInputHandler
{

	const ID = 'sort_dialog';
	const SORT_DIALOG_WIDTH = 980;
	const SORT_METHOD_ATTR_NAME = 'sorting_method_idx';

	///////////////////////////////////////////////////////////////////////

	private	$owner;
	private	$plugin;
	private	$hashed_arrays;
	private	$ch_sort_method_idx;
	private	$hd_ch_sort_method_idx;

	///////////////////////////////////////////////////////////////////////

	private static	$hd_channels_ids;
	private static	$uhd_channels_ids;

	private static	$sort_method_ops =
		array
		(
			'0' => 'по номеру',
			'1' => 'по названию',
		);

	private static	$hd_sort_method_ops =
		array
		(
			'0' => 'порядок по умолчанию',
			'2' => 'на вершину списка',
		);

	///////////////////////////////////////////////////////////////////////
	// Sort functions

	public static function sort_ch_by_number($a, $b)
	{
		return
			strnatcasecmp($a->get_number(), $b->get_number());
	}

	public static function sort_ch_by_title($a, $b)
	{
		return
			strnatcasecmp($a->get_title(), $b->get_title());
	}

	public static function sort_ch_by_number_priority_hd($a, $b)
	{
		$a_is_uhd = (strpos(self::$uhd_channels_ids, $a->get_id()) !== false);
		$b_is_uhd = (strpos(self::$uhd_channels_ids, $b->get_id()) !== false);
		$a_is_hd = !$a_is_uhd && (strpos(self::$hd_channels_ids, $a->get_id()) !== false);
		$b_is_hd = !$b_is_uhd && (strpos(self::$hd_channels_ids, $b->get_id()) !== false);

		if (($a_is_uhd && $b_is_uhd) || ($a_is_hd && $b_is_hd)): return strnatcasecmp($a->get_number(), $b->get_number());
			elseif ($a_is_uhd): return -1;
				elseif ($b_is_uhd): return 1;
					elseif ($a_is_hd): return -1;
						elseif ($b_is_hd): return 1;
							else: return strnatcasecmp($a->get_number(), $b->get_number());
		endif;
	}

	public static function sort_ch_by_title_priority_hd($a, $b)
	{
		$a_is_uhd = (strpos(self::$uhd_channels_ids, $a->get_id()) !== false);
		$b_is_uhd = (strpos(self::$uhd_channels_ids, $b->get_id()) !== false);
		$a_is_hd = !$a_is_uhd && (strpos(self::$hd_channels_ids, $a->get_id()) !== false);
		$b_is_hd = !$b_is_uhd && (strpos(self::$hd_channels_ids, $b->get_id()) !== false);

		if (($a_is_uhd && $b_is_uhd) || ($a_is_hd && $b_is_hd)): return strnatcasecmp($a->get_title(), $b->get_title());
			elseif ($a_is_uhd): return -1;
				elseif ($b_is_uhd): return 1;
					elseif ($a_is_hd): return -1;
						elseif ($b_is_hd): return 1;
							else: return strnatcasecmp($a->get_title(), $b->get_title());
		endif;
	}

	////////////////////////////////////////////////////////////////////////////

	public function __construct(&$plugin)
	{
		$this->plugin = $plugin;
		$this->ch_sort_method_idx = 0;
		$this->hd_ch_sort_method_idx = 0;
		UserInputHandlerRegistry::get_instance()->register_handler($this);
	}

	public function get_handler_id()
	{
		return self::ID.'_handler';
	}

	public function get_sort_func(&$plugin_cookies)
	{
		$hd_group = $this->plugin->tv->get_group(HomeTv::HDTV_CHANNELS_GROUP_ID);
		$uhd_group = $this->plugin->tv->get_group(HomeTv::UHDTV_CHANNELS_GROUP_ID);
		self::$hd_channels_ids = isset($hd_group['channels'])? serialize($hd_group['channels']) : '';
		self::$uhd_channels_ids = isset($uhd_group['channels'])? serialize($uhd_group['channels']) : '';

		if (!isset($plugin_cookies->{self::SORT_METHOD_ATTR_NAME}))
			$plugin_cookies->{self::SORT_METHOD_ATTR_NAME} = ($this->ch_sort_method_idx + $this->hd_ch_sort_method_idx);

		switch ($plugin_cookies->{self::SORT_METHOD_ATTR_NAME})
		{
			case '0':
				return 'Sorter::sort_ch_by_number';

			case '1':
				return 'Sorter::sort_ch_by_title';

			case '2':
				return 'Sorter::sort_ch_by_number_priority_hd';

			default:
				return 'Sorter::sort_ch_by_title_priority_hd';
		}
	}

	public function sort_channels(&$plugin_cookies)
	{
		$sort_func = $this->get_sort_func($plugin_cookies);

		foreach (func_get_args() as $idx => $hashed_array)
		{
			if (empty($idx))
				continue;

			$hashed_array->usort($sort_func);
		}
	}

	protected function get_dialog_controls_defs()
	{
		ControlFactory::add_vgap($defs, 10);
		ControlFactory::add_combobox($defs, $this, null, 'ch_sort_combobox', ' Сортировать  ', $this->ch_sort_method_idx, self::$sort_method_ops, 600, true);
		ControlFactory::add_combobox($defs, $this, null, 'hd_ch_sort_combobox', ' HD каналы', $this->hd_ch_sort_method_idx, self::$hd_sort_method_ops, 600, true);
		ControlFactory::add_vgap($defs, 40);
		ControlFactory::add_close_dialog_and_apply_button($button_defs, $this, null, 'do_sort_channels', 'Применить', 350);
		ControlFactoryExt::add_button_centered($defs, $button_defs, self::SORT_DIALOG_WIDTH);
		ControlFactory::add_close_dialog_button($button_defs, 'Отмена', 350);
		ControlFactoryExt::add_button_centered($defs, $button_defs, self::SORT_DIALOG_WIDTH);
		ControlFactory::add_vgap($defs, 10);

		return $defs;
	}

	public function handle_user_input(&$user_input, &$plugin_cookies)
	{
		$control_id = $user_input->control_id;

		switch ($control_id)
		{
			case 'do_show_dialog':
				if (isset($plugin_cookies->{self::SORT_METHOD_ATTR_NAME}))
					switch ($plugin_cookies->{self::SORT_METHOD_ATTR_NAME})
					{
						case '0':
							$this->ch_sort_method_idx = 0;
							$this->hd_ch_sort_method_idx = 0;
							break;
						case '1':
							$this->ch_sort_method_idx = 1;
							$this->hd_ch_sort_method_idx = 0;
							break;
						case '2':
							$this->ch_sort_method_idx = 0;
							$this->hd_ch_sort_method_idx = 2;
							break;
						case '3':
							$this->ch_sort_method_idx = 1;
							$this->hd_ch_sort_method_idx = 2;
					}

				return
					ActionFactorySafe::show_dialog('Сортировка каналов', $this->get_dialog_controls_defs(), true, self::SORT_DIALOG_WIDTH);

		case 'ch_sort_combobox':
				$this->ch_sort_method_idx = $user_input->{$control_id};
				break;

		case 'hd_ch_sort_combobox':
				$this->hd_ch_sort_method_idx = $user_input->{$control_id};
				break;

		case 'do_sort_channels':
				$plugin_cookies->{self::SORT_METHOD_ATTR_NAME} = ($this->ch_sort_method_idx + $this->hd_ch_sort_method_idx);

				foreach ($this->hashed_array as $hashed_array)
					$this->sort_channels($plugin_cookies, $hashed_array);

				$range = $this->owner->get_folder_range(MediaURL::decode($user_input->parent_media_url), 0, $plugin_cookies);
				$post_action = ActionFactorySafe::update_regular_folder($range, true, $user_input->sel_ndx);

				if (class_exists("PluginRowsFolderView") && class_exists('EpfsHandler'))
				{
					EpfsHandler::update_tv_epfs($plugin_cookies);

					return
						EpfsHandler::invalidate_folders(null, $post_action);
				}

				return
					$post_action;
		}

		return
			ActionFactorySafe::reset_controls($this->get_dialog_controls_defs());
	}

	public function show(&$owner_handle)
	{
		$this->owner = $owner_handle;
		$hashed_arrays = array();

		foreach (func_get_args() as $idx => $hashed_array)
		{
			if (empty($idx))
				continue;

			$this->hashed_array[] = $hashed_array;
		}

		return
			UserInputHandlerRegistry::create_action($this, 'do_show_dialog');
	}

	////////////////////////////////////////////////////////////////////////////
}

?>
