<?php

###############################################################################
#
# Показ сплешскрина
#
# Работает на прошивках b9, r10+
#
# SplashScreen::init(&$plugin, ...) - инициализация (при создании плагина)
# SplashScreen::open_and_run($post_action) - показать сплеш и выполнить действие
# SplashScreen::close_and_run($post_action) - скрыть сплеш и выполнить действие
# SplashScreen::refresh($display_widget, $post_action) - обновить сплеш и выполнить действие (r11+)
#
# Автор (Author): Brigadir (forum.mydune.ru)
# Почта (Email): brigadir@mydune.ru
# Дата (Date): 24-04-2018
# Последнее обновление (Latest update): 24-12-2020
#
###############################################################################

///////////////////////////////////////////////////////////////////////////////

require_once 'lib/screen.php';
require_once 'lib/dune_stb_api.php';
require_once 'lib/user_input_handler.php';
require_once 'lib/action_factory_safe.php';

///////////////////////////////////////////////////////////////////////////////

class SplashScreen implements Screen, UserInputHandler
{
	const	ID	= 'splash_screen';

	private static	$instance = null;
	private static	$firmware_bn;

	private $displayed;
	private $display_widget;
	private $splash_background_url;

	///////////////////////////////////////////////////////////////////////////

	private function __construct(&$plugin = null)
	{
		$fw = get_parsed_firmware_ver();
		self::$firmware_bn = $fw['branch_num'];

		if (self::$firmware_bn < 11)
			return;

		DefaultDunePlugin::create_screen($this);
		UserInputHandlerRegistry::get_instance()->register_handler($this);
    }

	///////////////////////////////////////////////////////////////////////

	public static function init(&$plugin = null, $screen_bg_url = null)
	{
		if (is_null(self::$instance))
			self::$instance = new SplashScreen($plugin);

		self::$instance->splash_background_url = empty($screen_bg_url)? '' : $screen_bg_url;
		self::$instance->displayed = false;
		self::$instance->display_widget = false;
	}

	public static function open_and_run($post_action = null)
	{
		if (is_array($post_action))
			$post_action[GuiAction::params]['dialog_frame_style'] = (self::$firmware_bn <= 8)? DIALOG_FRAME_STYLE_DEFAULT : DIALOG_FRAME_STYLE_GLASS;

		$displayed = self::$instance->displayed;
		self::$instance->displayed = true;

		if ($displayed && ((get_platform_kind() == 'android') || (self::$firmware_bn > 10)))
			return $post_action;

		if (self::$firmware_bn <= 9)
		{
			if (self::$firmware_bn <= 8)
				return $post_action;

			return
				ActionFactorySafe::show_black_screen(self::$instance->splash_background_url, $post_action);
		}

		if (self::$firmware_bn == 10)
			return
				ActionFactorySafe::show_black_screen(self::$instance->splash_background_url, $post_action);

		$open_folder_action =
			array
			(
				GuiAction::handler_string_id => PLUGIN_OPEN_FOLDER_ACTION_ID,
				GuiAction::data =>
					array
					(
						PluginOpenFolderActionData::media_url => MediaURL::decode(self::ID)->get_raw_string(),
						PluginOpenFolderActionData::caption => '',
						PluginOpenFolderActionData::post_action => $post_action,
					),
			);

		return
			$displayed? ActionFactorySafe::close_and_run($open_folder_action) : $open_folder_action;
	}

	public static function close_and_run($post_action = null)
	{
		if (self::$instance->displayed)
		{
			self::$instance->displayed = false;

			if (self::$firmware_bn <= 9)
			{
				if (self::$firmware_bn <= 8)
					return $post_action;

				return
					ActionFactorySafe::show_main_screen($post_action);
			}

			if (self::$firmware_bn == 10)
				return
					ActionFactorySafe::show_main_screen($post_action);

			return ActionFactorySafe::close_and_run($post_action);
		}

		return $post_action;
	}

	public static function refresh($display_widget, $post_action = null)
	{
		if (!self::$instance->displayed)
			return null;

		self::$instance->display_widget = $display_widget;

		return
			ActionFactorySafe::invalidate_folders(array(MediaURL::decode(self::ID)->get_raw_string()), $post_action);
	}

	public static function get_autoclose_action()
	{
		return
			array
			(
				GUI_EVENT_TIMER => UserInputHandlerRegistry::create_action($this, GUI_EVENT_TIMER),
			);
	}

	///////////////////////////////////////////////////////////////////////

    public function get_id()
    {
    	return self::ID;
    }

	public function get_handler_id()
	{
		return self::ID.'_handler';
	}

    public function get_folder_view(MediaURL $media_url, &$plugin_cookies)
    {
	    return
			array
			(
				PluginFolderView::multiple_views_supported => false,
				PluginFolderView::archive => null,
				PluginFolderView::view_kind => PLUGIN_FOLDER_VIEW_REGULAR,
				PluginFolderView::data =>
					array
					(
						PluginRegularFolderView::async_icon_loading => true,
						PluginRegularFolderView::view_params =>
							array
							(
								FolderViewParams::paint_path_box => false,
								FolderViewParams::paint_help_line => false,
								FolderViewParams::paint_icon_selection_box=> false,
								FolderViewParams::paint_content_box_background => false,
								FolderViewParams::paint_widget => $this->display_widget,
								FolderViewParams::content_box_x => -100,
								FolderViewParams::content_box_y => -100,
								FolderViewParams::content_box_width => 100,
								FolderViewParams::content_box_height => 100,
								FolderViewParams::background_order => 0,
								FolderViewParams::background_path => $this->splash_background_url,
								FolderViewParams::optimize_full_screen_background => true,
							),
						PluginRegularFolderView::base_view_item_params => array(),
						PluginRegularFolderView::not_loaded_view_item_params => array(),
						PluginRegularFolderView::actions =>
							array
							(
								GUI_EVENT_TIMER => UserInputHandlerRegistry::create_action($this, GUI_EVENT_TIMER),
							),
						PluginRegularFolderView::timer => ActionFactorySafe::timer(1),
						PluginRegularFolderView::initial_range =>
							array
							(
								PluginRegularFolderRange::total => 0,
								PluginRegularFolderRange::from_ndx => 0,
								PluginRegularFolderRange::count => 0,
								PluginRegularFolderRange::items => array(),
							),
					),
			);
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
		if (isset($user_input->control_id))
			if ($user_input->control_id == GUI_EVENT_TIMER)
			{
				$this->displayed = false;

				return
					ActionFactorySafe::close_and_run();
			}

		return null;
	}
}
?>
