<?php

class TvChannel
{
	protected $_id;
	protected $_number;
	protected $_title;
	protected $_desc;
	protected $_is_adult;
	protected $_groups;
	protected $_qfilter;
	protected $_hls_bs_prefer;
	protected $_subchannels;
	protected $_subchannel_id;
	protected $_def_subchannel_id;
	protected $_dvb_subchannels;
	protected $_user_data;
	protected $_epg_ids;

	////////////////////////////////////////////////////////////////////////////

	public function __construct(
			$id,
			$number,
			$title,
			$desc,
			$qfilter,
			$hls_bs_prefer,
			$subchannels,
			$dvb_subchannels,
			&$user_data)
	{
		$this->_id = md5("{$number}_{$id}");
		$this->_number = $number;
		$this->_title = preg_replace('/(\s(HD|4[KК]))+$/u', '', $title);
		$this->_desc = $desc;
		$this->_qfilter = $qfilter;
		$this->_hls_bs_prefer = $hls_bs_prefer;
		$this->_subchannels = $subchannels;
		$this->_dvb_subchannels = $dvb_subchannels;
		$this->_user_data = $user_data;

		// Вычисление идентификатора субканала /////////////////////////////////
		$subchannel_ids = array();

		foreach ($this->_subchannels as $id => $channel)
		{
			$sub = array();

			if (!empty($channel['npvrId']))
				$sub[$channel['quality']]['npvrId'] = $id;

			if (!empty($channel['ottUrl']))
				$sub[$channel['quality']]['ottUrl'] = $id;

			if ($this->_qfilter == QualityDefs::lowest)
			{
				if (isset($sub['sd']['ottUrl']))
					$subchannel_ids[0][] = $sub['sd']['ottUrl'];
			}
			else if ($this->_qfilter == QualityDefs::middle)
			{
				if ($this->_hls_bs_prefer == HttpStreamsDefs::hls_cbr)
				{
					if (isset($sub['hd']['ottUrl']))
						$subchannel_ids[0][] = $sub['hd']['ottUrl'];

					if (isset($sub['sd']['ottUrl']))
						$subchannel_ids[1][] = $sub['sd']['ottUrl'];
				}
				else if ($this->_hls_bs_prefer == HttpStreamsDefs::hls_abs)
				{
					if (isset($sub['hd']['ottUrl']))
						$subchannel_ids[0][] = $sub['hd']['ottUrl'];

					if (isset($sub['sd']['ottUrl']))
						$subchannel_ids[1][] = $sub['sd']['ottUrl'];
				}
			}
			else
			{
				if (isset($sub['4k']['ottUrl']))
					$subchannel_ids[0][] = $sub['4k']['ottUrl'];

				if (isset($sub['hd']['ottUrl']))
					$subchannel_ids[1][] = $sub['hd']['ottUrl'];

				if (isset($sub['sd']['ottUrl']))
					$subchannel_ids[2][] = $sub['sd']['ottUrl'];
			}

			if (is_array($channel['epg']))
				foreach ($channel['epg'] as $epg)
					if ($matches = explode('@', $epg))
						$this->_epg_ids[$id][$matches[0]] = $matches[1];
		}

		if (ksort($subchannel_ids))
			foreach ($subchannel_ids as $ids)
				if (ksort($ids))
					foreach ($ids as $sub_id)
						if (!empty($this->_subchannels[$sub_id]['logo']))
						{
							$this->_def_subchannel_id = $sub_id;
							break 2;
						}

		if (empty($this->_def_subchannel_id))
			$this->_def_subchannel_id = $id;

		$this->_subchannel_id = $this->_def_subchannel_id;
		$this->_is_adult = false;
		$this->_groups = array();
	}

	////////////////////////////////////////////////////////////////////////////

	protected function select_subchannel($subchannel_id = null)
	{
		$this->_user_data->select($this->_id);
		$this->_subchannel_id = empty($subchannel_id)? (is_null($custom_subchannel_id = $this->_user_data->subchannel_id)? $this->_def_subchannel_id : (isset($this->_subchannels[$custom_subchannel_id])? $custom_subchannel_id : $this->_def_subchannel_id)) : $subchannel_id;
	}

	////////////////////////////////////////////////////////////////////////////

	public function get_id()
	{ return $this->_id; }

	public function get_number()
	{ return $this->_number; }

	public function get_def_title()
	{
		$this->select_subchannel();
		$q = $this->_subchannels[$this->_subchannel_id]['quality'];

		return
			$this->_title . (($q == 'sd')? '' : (($q == '4k')? (preg_match('/(\s4[KК])+$/u', $this->_subchannels[$this->_subchannel_id]['bcName'])? ' 4K' : '') : ' HD'));
	}

	public function get_title($not_custom_value = false)
	{
		if (is_null($custom_title = $this->_user_data->title))
			return
				$this->get_def_title();

		return
			$custom_title;
	}

	public function get_desc()
	{ return $this->_desc; }

	public function get_icon_url($subchannel_id = null)
	{
		$this->_user_data->select($this->_id);

		if (empty($subchannel_id) && !is_null($custom_icon_url = $this->_user_data->icon_url))
			return
				preg_match('/http.*:\/\//', $custom_icon_url)? ICONS_CACHE_PATH . '/' . md5("{$this->_number}_{$custom_icon_url}") . '.' . pathinfo($custom_icon_url, PATHINFO_EXTENSION) : $custom_icon_url;

		$this->select_subchannel($subchannel_id);
		$url = $this->_user_data->live_streaming_url;
		$sep = is_null($url)? (is_null($url = $this->get_dvb_streaming_url())? '/' : '/dvb/') : ((strpos($url, 'dvb://') !== false)? '/dvb/' : '/');
		$icon_url = preg_match('/\//u', $this->_subchannels[$this->_subchannel_id]['logo'])? $this->_subchannels[$this->_subchannel_id]['logo'] : ICONS_CACHE_PATH  . "/c160x115$sep" . $this->_subchannels[$this->_subchannel_id]['logo'];

		return
			file_exists($icon_url)? $icon_url : str_replace($sep, '/', $icon_url);
	}

	public function get_groups()
	{ return $this->_groups; }

	public function get_genres()
	{
		$this->select_subchannel();

		return
			is_array($genres = $this->_subchannels[$this->_subchannel_id]['genres'])? $genres : (empty($genres)? array() : array($genres));
	}

	public function has_archive()
	{
		return
			is_null($this->get_ott_hls_url())? (($this->_hls_bs_prefer == HttpStreamsDefs::hls_cbr)? !is_null($this->get_npvr_id()) : true) : true;
	}

	public function get_timeshift_hours()
	{
		$this->_user_data->select($this->_id);

		return
			is_null($custom_timeshift_hours = $this->_user_data->epg_timeshift)? 0 : intval($custom_timeshift_hours);
	}

	public function get_subchannels()
	{
		return $this->_subchannels;
	}

	public function get_npvr_id()
	{
		$this->select_subchannel();
		$result = $this->_subchannels[$this->_subchannel_id]['npvrId'];

		if (empty($result))
		{
			$selected_subchannel_quality = $this->_subchannels[$this->_subchannel_id]['quality'];

			foreach ($this->_subchannels as $subchannel)
			{
				if ($subchannel['quality'] == $selected_subchannel_quality)
				{
					$result = $subchannel['npvrId'];

					if (!empty($result))
						break;
				}
				else if (($this->_qfilter <> QualityDefs::lowest) && ($subchannel['quality'] <> 'sd') && ($selected_subchannel_quality <> 'sd'))
					$result = $subchannel['npvrId'];
				else if (($subchannel['quality'] == 'sd') && ($selected_subchannel_quality == 'sd'))
					$result = $subchannel['npvrId'];
			}
		}

		return
			empty($result)? null : $result;
	}

	public function get_def_subchannel_id()
	{
		return $this->_def_subchannel_id;
	}

	public function get_ott_hls_url()
	{
		$this->select_subchannel();

		if (!is_null($custom_tv_archive_url = $this->_user_data->tv_archive_url) && ($custom_tv_archive_url <> 'empty'))
			return $custom_tv_archive_url;

		return
			empty($this->_subchannels[$this->_subchannel_id]['ottUrl'])? null : $this->_subchannels[$this->_subchannel_id]['ottUrl'];
	}

	public function get_ott_mpd_url()
	{
		$this->select_subchannel();

		if (!is_null($custom_tv_archive_url = $this->_user_data->tv_archive_url) && ($custom_tv_archive_url <> 'empty'))
			return $custom_tv_archive_url;

		$result = isset($this->_subchannels[$this->_subchannel_id]['ottUrl'])? $this->_subchannels[$this->_subchannel_id]['ottUrl'] : '';

		return
			empty($result)? null : $result;
	}

	public function get_poster()
	{
		$this->select_subchannel();

		return
			empty($this->_subchannels[$this->_subchannel_id]['poster'])? null : $this->_subchannels[$this->_subchannel_id]['poster'];
	}

	public function mark_as_adult()
	{ $this->_is_adult = true;}

	public function is_adult()
	{ return $this->_is_adult; }

	public function get_streaming_url($ret_dvb_url = false)
	{
		$url = $ret_dvb_url? $this->get_dvb_streaming_url() : '';

		return
			empty($url)? null : $url;
	}

	public function get_dvb_streaming_url()
	{
		$url = '';

		if (is_array($this->_dvb_subchannels))
		{
			$is_hd = $this->is_hd();
			$is_uhd = $this->is_uhd();

			foreach ($this->_dvb_subchannels as $sub)
			{
				if (($sub['res'] == 'sd') && !$is_hd)
					return $sub['url'];

				if (($sub['res'] == 'hd') && $is_hd)
					return $sub['url'];

				if (($sub['res'] == '4k') && $is_uhd)
					return $sub['url'];

				if (($sub['res'] == '4k') && !$is_uhd)
					$url = $sub['url'];
				else if (($sub['res'] == 'hd') && $is_uhd)
					$url = $sub['url'];
			}
		}

		return empty($url)? null : $url;
	}

	public function get_dvb_subchannels()
	{
		return
			is_array($this->_dvb_subchannels)? $this->_dvb_subchannels : array();
	}

	public function is_hd()
	{
		$this->select_subchannel();

		if (is_null($custom_title = $this->_user_data->title))
			return
				($this->_subchannels[$this->_subchannel_id]['quality'] <> 'sd');

		return
			preg_match('/\s+(4K|HD|UHD)$/ui', trim($custom_title));
	}

	public function is_uhd()
	{
		$this->select_subchannel();

		if (is_null($custom_title = $this->_user_data->title))
			return
				($this->_subchannels[$this->_subchannel_id]['quality'] == '4k');

		return
			preg_match('/\s+(4K|UHD)$/ui', trim($custom_title));
	}

	////////////////////////////////////////////////////////////////////////////

	public function add_group($group_id)
	{
		$this->_groups[] = $group_id;
		$this->_groups = array_unique($this->_groups);
	}

	public function remove_group($group_id)
	{
		$found = array_search($group_id, $this->_groups);

		if ($found !== false)
			unset($this->_groups[$found]);
	}

	////////////////////////////////////////////////////////////////////////////

	public function get_epg_ids()
	{
		$this->select_subchannel();

		return
			$this->_epg_ids[$this->_subchannel_id];
	}

	////////////////////////////////////////////////////////////////////////////
}

?>
