<?php

class TvChannelsEditor implements UserInputHandler
{

	const ID = 'channels_editor';
	const TXT_SPLIT_LENGTH = 53;

	private	$plugin;
	private $channel;
	private $screen_handle;
	private $custom_title;
	private $custom_icon_url;
	private $icon_urls_list;
	private $icon_urls_list_idx;
	private $custom_subchannel;
	private $subchannels_list;
	private $subchannels_list_idx;
	private $dvb_urls_list;
	private $hls_urls_list;
	private $mpd_urls_list;
	private $live_streaming_urls_list_idx;
	private $custom_live_streaming_url;
	private $tv_archive_urls_list_idx;
	private $custom_tv_archive_url;
	private $epg_ids_list;
	private $epg_ids_list_idx;
	private $custom_epg_id;
	private	$epg_timeshift_hours_idx;
	private $need_refresh;
	private $location_info;
	private $zoom_presets_list_idx;
	private $deinterlacing_modes_list_idx;

	protected static $epg_timeshift_ops = array(
		'-9'	=> '-9 часов',
		'-8'	=> '-8 часов',
		'-7'	=> '-7 часов',
		'-6'	=> '-6 часов',
		'-5'	=> '-5 часов',
		'-4'	=> '-4 часа',
		'-3'	=> '-3 часа',
		'-2'	=> '-2 часа',
		'-1'	=> '-1 час',
		'0'		=> '0 (По умолчанию)',
		'1'		=> '+1 час',
		'2'		=> '+2 часа',
		'3'		=> '+3 часа',
		'4'		=> '+4 часа',
		'5'		=> '+5 часов',
		'6'		=> '+6 часов',
		'7'		=> '+7 часов',
		'8'		=> '+8 часов',
		'9'		=> '+9 часов',
	);

	protected static $zoom_presets_ops =
		array
		(
			'default'								=> 'По умолчанию',
			DuneVideoZoomPresets::normal			=> 'Обычный',
			DuneVideoZoomPresets::full_enlarge		=> 'Полный экран',
			DuneVideoZoomPresets::full_stretch		=> 'Растяжение на весь экран',
			DuneVideoZoomPresets::fill_screen		=> 'Нелинейное растяжение',
			DuneVideoZoomPresets::full_fill_screen	=> 'Нелинейное растяжение на весь экран',
			DuneVideoZoomPresets::enlarge			=> 'Увеличение',
			DuneVideoZoomPresets::make_wider		=> 'Увеличение ширины',
			DuneVideoZoomPresets::make_taller		=> 'Увеличение высоты',
			DuneVideoZoomPresets::cut_edges			=> 'Обрезка краев',
		);

	protected static $deinterlacing_modes_ops =
		array
		(
			'default'								=> 'По умолчанию',
			DuneParamsDeintMode::off				=> 'Отключен',
			DuneParamsDeintMode::bob				=> 'Бикубический (bob)',
			DuneParamsDeintMode::adaptive			=> 'Адаптивный',
			DuneParamsDeintMode::adaptive_plus		=> 'Адаптивный +',
		);

	protected static $editor_ctrls_hints = //123
		array
		(
			'title_field'							=> 'Отредактируйте название и подтвердите нажатием ENTER. Добавьте HD |через пробел к названию, чтобы канал воспринимался как HD. Очистите |поле чтобы вернуть значение по умолчанию (из плейлиста провайдера).',
			'icon_url_field'						=> 'Введите URL иконки и подтвердите нажатием ENTER. Поддерживаются |только HTTP протокол передачи данных и возможные типы файлов: *.jpg, |*.png, *.bmp. Очистите поле чтобы вернуть иконку по умолчанию.',
			'subchannels_list_combo'				=> 'Выбор субканала влияет на автоподбор зависимых параметров. Выберите |субканал из списка или используйте "Автоподбор" для автоматического |подбора в соответствии со значением фильтра качества потоков.',
			'live_urls_list_combo'					=> 'Измените URL прямой трансляции (Live), если это необходимо. Выберите |значение из списка или добавьте новый URL. Используйте "Автоподбор", |чтобы использовать значение в соответствии с выбранным субканалом и |заданными опциями плагина.',
			'custom_live_streaming_url_field'		=> 'Введите URL прямой трансляции (Live) и подтвердите нажатием ENTER. При |подтверждении действует автоподстановка префиксов "udp://@" и "http://" |перед введенной строкой. Нажмите ENTER чтобы вернуться к списку.',
			'archive_urls_list_combo'				=> 'Измените URL архива, если это необходимо. Выберите значение из списка |или добавьте новый URL. Используйте "Автоподбор", чтобы использовать |значение в соответствии с выбранным субканалом и заданными опциями |плагина.',
			'tv_archive_deactivate_btn'				=> 'Архив на данном канале деактивирован и недоступен. Нажмите ENTER для |активации, выберите из списка необходимое значение или добавьте URL.',
			'icon_urls_list_combo'					=> 'Выбор иконки (логотипа) телеканала.',
			'title_mode_btn'						=> 'Название телеканала. Нажмите ENTER чтобы изменить.',
			'custom_tv_archive_url_field'			=> 'Введите значение и подтвердите нажатием ENTER. Не забудьте включить в |ссылку метки автоподстанова начального, конечного и текущего времени, |разницы между начальным и текущим временем (оффсет): {b}, {e}, {t} и |{o}. Нажмите ENTER, чтобы вернуться к списку.',
			'epg_ids_list_combo'					=> 'Выберите идентификатор канала поставщика программы передач из списка |или добавьте новый. Используйте "Автоподбор", чтобы использовать |значение в соответствии с выбранным субканалом и заданными |опциями плагина.',
			'custom_epg_id_field'					=> 'Введите строку идентификатора и подтвердите нажатием ENTER. |Поддерживаются сервисы: rt, smartlabs, yandex и vsetv (например |rt@1000069, smartlabs@http://channel_epg_url, yandex@1877@10995, |vsetv@201). Нажмите ENTER, чтобы вернуться к списку.',
			'epg_deactivate_btn'					=> 'Телегид на данном канале деактивирован, телепрограмма недоступна. |Нажмите для активации, выберите из списка необходимое значение или |добавьте новый идентификатор.',
			'epg_timeshift_combo'					=> 'Скорректируйте сдвиг времени для программы передач канала, если это |необходимо. Значение применяется к любому выбранному источнику |программы передач.',
			'zoom_mode_list_combo'					=> 'Задайте вариант масштабирования изображения на экране из доступных, |либо выберите "По умолчанию", чтобы использовать системное значение.',
			'deinterlacing_mode_list_combo'			=> 'Задайте метод деинтерлейсинга изображения на экране из доступных, либо |выберите "По умолчанию", чтобы использовать системное значение.',
			'ch_editor_save_btn'					=> '',
			'ch_editor_change_mode_btn'				=> '',
			'ch_editor_close_and_update_btn'		=> '',
		);
	////////////////////////////////////////////////////////////////////////////

	public function __construct(&$plugin)
	{
		$this->plugin = $plugin;
		UserInputHandlerRegistry::get_instance()->register_handler($this);
	}

	public function get_handler_id()
	{
		return self::ID . '_handler';
	}

	public function get_epg_timeshift_ops()
	{
		return self::$epg_timeshift_ops;
	}

	public function get_zoom_presets_ops()
	{
		return self::$zoom_presets_ops;
	}

	public function get_deinterlacing_modes_ops()
	{
		return self::$deinterlacing_modes_ops;
	}

	protected function initialize($channel_id, &$add_params)
	{
		$this->plugin->user_data->select($channel_id);
		$this->custom_title = $this->plugin->user_data->title;
		$this->channel = $this->plugin->tv->get_channel($channel_id);

		if (is_null($this->channel))
			throw new Exception(get_class($this).": Unknown channel: $channel_id");

		$this->epg_timeshift_hours_idx = $this->channel->get_timeshift_hours();
		$this->custom_subchannel = is_null($custom_subchannel = $this->plugin->user_data->subchannel_id)? null : $custom_subchannel;
		$this->custom_icon_url = is_null($custom_icon_url = $this->plugin->user_data->icon_url)? null : $custom_icon_url;
		$this->custom_epg_id = is_null($custom_epg_id = $this->plugin->user_data->epg_id)? null : $custom_epg_id;
		$add_param['live_url'] = $this->plugin->tv->get_tv_playback_url($this->channel->get_id(), 0, RET_LIVE_TEMPLATE_URL);
		$this->icon_urls_list = array('auto' => 'Автоподбор');
		$this->dvb_urls_list = array('auto' => 'Автоподбор');
		$this->hls_urls_list = array('auto' => 'Автоподбор');
		$this->mpd_urls_list = array('auto' => 'Автоподбор');
		$this->epg_ids_list = array('empty' => 'Деактивировать', 'auto' => 'Автоподбор');

		foreach ($this->channel->get_dvb_subchannels() as $sub_data)
			$this->dvb_urls_list[$sub_data['url']] = (($sub_data['res'] == 'sd')? '[DVB SD] ' : (($sub_data['res'] == 'hd')? '[DVB HD] ' : '[DVB UHD] ')) . $sub_data['url'];

		$this->subchannels_list = $this->channel->get_subchannels();
		$this->location_info = Wink()->get_location_info();
		$epg_ids = array();

		foreach ($this->subchannels_list as $bcid => $sub_data)
		{
			$icon_url = $this->channel->get_icon_url($bcid);

			if (!empty($icon_url))
				$this->icon_urls_list[$icon_url] = basename($icon_url);

			if (!empty($sub_data['ottUrl']))
				if (preg_match('/\/hls\/CH_.*t\.m3u8/', $sub_data['ottUrl']))
					$this->hls_urls_list[$sub_data['ottUrl']] = (($sub_data['quality'] == 'sd')? '[HLS SD] ' : '[HLS HD] ') . $sub_data['ottUrl'];
				else if (preg_match('/\/mdrm\/CH_.*t\.mpd/', $sub_data['ottUrl']))
					$this->mpd_urls_list[$sub_data['ottUrl']] = (($sub_data['quality'] == 'sd')? '[MPD SD] ' : '[MPD HD] ') . $sub_data['ottUrl'];

			foreach ($sub_data['epg'] as $epg)
				if (stripos($epg, 'yandex') === false)
					$epg_ids["$epg"] = "$epg ({$sub_data['bcName']})";
				else
					$epg_ids["$epg"] = "$epg@{$this->location_info->yid} ({$sub_data['bcName']})";
		}

		ksort($epg_ids);
		$this->epg_ids_list = array_merge($this->epg_ids_list, $epg_ids);
		$this->subchannels_list_idx = is_null($custom_subchannel)? 'auto' : (isset($this->subchannels_list[$custom_subchannel])? $custom_subchannel : 'auto');
		$this->icon_urls_list_idx = is_null($custom_icon_url)? 'auto' : (is_null($icon_urls_list = $this->get_icon_urls_list())? 'auto' : (isset($icon_urls_list[$this->custom_icon_url])? $this->custom_icon_url : 'auto'));
		$this->epg_ids_list_idx = is_null($custom_epg_id)? 'auto' : (is_null($epg_ids_list = $this->get_epg_ids_list())? 'auto' : (isset($epg_ids_list[$this->custom_epg_id])? $this->custom_epg_id : 'auto'));
		$urls_list = $this->get_live_streaming_urls_list();
		$this->live_streaming_urls_list_idx = is_null($this->custom_live_streaming_url = $this->plugin->user_data->live_streaming_url)? 'auto' : (isset($urls_list[$this->custom_live_streaming_url])? $this->custom_live_streaming_url : 'auto');
		$this->custom_tv_archive_url = is_null($tmp = $this->plugin->user_data->tv_archive_url)? '' : $tmp;
		$urls_list = $this->get_tv_archive_urls_list();
		$this->tv_archive_urls_list_idx = empty($this->custom_tv_archive_url)? 'auto' : (($this->custom_tv_archive_url == 'empty')? 'empty' : (isset($urls_list[$this->custom_tv_archive_url])? $this->custom_tv_archive_url : 'auto'));
		$this->zoom_presets_list_idx = is_null($tmp = $this->plugin->user_data->zoom)? 'default' : $tmp;
		$this->deinterlacing_modes_list_idx = is_null($tmp = $this->plugin->user_data->deint)? 'default' : $tmp;
	}

	protected function get_subchannels_list()
	{
		$result = array();
		$result['auto'] = 'Автоподбор';

		foreach ($this->subchannels_list as $id => $data)
			$result[$id] = $data['bcName'] . " ({$data['bcNumber']})";

		return $result;
	}

	protected function get_icon_urls_list()
	{
		$result = array_unique($this->icon_urls_list);

		if (count($result) == 1)
			unset($this->icon_urls_list['auto']);

		if (!empty($this->custom_icon_url) && !isset($result[$this->custom_icon_url]))
		{
			$result[$this->custom_icon_url] = '[Custom] ' . $this->custom_icon_url;
			$result['edit'] = 'Редактировать';
		}
		else
			$result['custom'] = 'Добавить';

		return $result;
	}

	protected function get_live_streaming_urls_list()
	{
		$result = $this->dvb_urls_list + $this->hls_urls_list + $this->mpd_urls_list;

		if (!empty($this->custom_live_streaming_url) && (array_search($this->custom_live_streaming_url, array_flip($result)) === false))
			$result[$this->custom_live_streaming_url] = '[Custom] ' . $this->custom_live_streaming_url;

		if (count($result) == 1)
			unset($result['auto']);

		$result['custom'] = empty($this->custom_live_streaming_url)? 'Добавить' : 'Редактировать';

		return $result;
	}

	protected function get_tv_archive_urls_list()
	{
		$result = array_merge(array('empty' => 'Деактивировать'), $this->hls_urls_list + $this->mpd_urls_list);

		if (!empty($this->custom_tv_archive_url) && ($this->custom_tv_archive_url <> 'empty') && (array_search($this->custom_tv_archive_url, array_flip($result)) === false))
			$result[$this->custom_tv_archive_url] = '[Custom] ' . $this->custom_tv_archive_url;

		if (count($result) == 1)
			unset($result['auto']);

		$result['custom'] = (empty($this->custom_tv_archive_url) || ($this->custom_tv_archive_url == 'empty'))? 'Добавить' : 'Редактировать';

		return $result;
	}

	protected function get_epg_ids_list()
	{
		$result = array_unique($this->epg_ids_list);

		if (count($result) == 1)
			unset($this->epg_ids_list['auto']);

		if (!empty($this->custom_epg_id) && ($this->custom_epg_id <> 'empty') && (array_search($this->custom_epg_id, array_flip($result)) === false))
			$result[$this->custom_epg_id] = '[Custom] ' . $this->custom_epg_id;

		$result['custom'] = (empty($this->custom_epg_id) || ($this->custom_epg_id == 'empty'))? 'Добавить' : 'Редактировать';

		return $result;
	}

	protected function get_dialog_controls_defs(&$add_params, &$plugin_cookies)
	{
		ControlFactory::add_label($defs, 'Номер кнопки', $this->channel->get_number());

		if ($add_params['dialog_mode'] == 'editor')
		{
			$title = empty($this->custom_title)? $this->channel->get_def_title() : $this->custom_title;

			if ($add_params['title_mode'] == 'edit')
				ControlFactory::add_text_field($defs, $this, array('dialog_is_shown' => true),
					'title_field',
					'Название',
					$title,
					false,
					false,
					false,
					false,
					1250,
					true);
			else
				ControlFactory::add_button($defs, $this, array('dialog_is_shown' => true), 'title_mode_btn', 'Название', $title, 1250, false);

			ControlFactory::add_vgap($defs, 10);
			ControlFactory::add_combobox($defs, $this, array('dialog_is_shown' => true),
				'subchannels_list_combo',
				'Субканал',
				$this->subchannels_list_idx,
				$this->get_subchannels_list(),
				1250,
				true);
			ControlFactory::add_vgap($defs, -14);
			ControlFactory::add_smart_label($defs, null, '<gap width=330/><icon width=54 height=54>' . PLUGIN_IMG_PATH . '/icon_badge.png' . '</icon>');
			ControlFactory::add_vgap($defs, -65);

			if (($this->icon_urls_list_idx == 'custom') || ($this->icon_urls_list_idx == 'edit'))
				ControlFactory::add_text_field($defs, $this, array('dialog_is_shown' => true),
					'icon_url_field',
					'  Иконка (URL)',
					empty($this->custom_icon_url)? '' : $this->custom_icon_url,
					false,
					false,
					false,
					false,
					1250,
					true);
			else
			{
				$subchannel_id = empty($this->custom_subchannel)? (($this->subchannels_list_idx == 'auto')? $this->channel->get_def_subchannel_id() : $this->subchannels_list_idx) : $this->custom_subchannel;
				ControlFactory::add_combobox($defs, $this, array('dialog_is_shown' => true),
					'icon_urls_list_combo',
					'  Иконка (URL)',
					$this->icon_urls_list_idx,
					$this->get_icon_urls_list(),
					1250,
					true);
				ControlFactory::add_vgap($defs, -69);
				ControlFactory::add_smart_label($defs, null, '<gap width=334/><icon width=64 height=46>' . (($this->icon_urls_list_idx <> 'auto')? $this->icon_urls_list_idx : $this->channel->get_icon_url($subchannel_id)) . '</icon>');
			}

			ControlFactory::add_vgap($defs, -10);

			if ($this->epg_ids_list_idx == 'custom')
				ControlFactory::add_text_field($defs, $this, array('dialog_is_shown' => true),
					'custom_epg_id_field',
					'  Телегид (ID)',
					empty($this->custom_epg_id)? '' : $this->custom_epg_id,
					false,
					false,
					false,
					false,
					1250,
					true);
			else if ($this->epg_ids_list_idx <> 'empty')
				ControlFactory::add_combobox($defs, $this, array('dialog_is_shown' => true),
					'epg_ids_list_combo',
					'  Телегид (ID)',
					$this->epg_ids_list_idx,
					$this->get_epg_ids_list(),
					1250,
					true);
			else
			{
				ControlFactory::add_button($defs, $this, null, 'epg_deactivate_btn', '  Телегид (ID)', 'Деактивирован', 1250, false);
				ControlFactory::add_vgap($defs, -65);
				ControlFactory::add_smart_label($defs, null,  '<gap width=' . (1600 - 95) . '/><icon>' . PLUGIN_IMG_PATH . '/' . (($this->epg_ids_list_idx <> 'empty')? 'on' : 'off') . '.png</icon>');
				ControlFactory::add_vgap($defs, -4);
			}

			ControlFactory::add_vgap($defs, -10);

			if ($this->live_streaming_urls_list_idx == 'custom')
				ControlFactory::add_text_field($defs, $this, array('dialog_is_shown' => true),
					'custom_live_streaming_url_field',
					'  Прямой эфир (URL)',
					$this->custom_live_streaming_url,
					false,
					false,
					false,
					false,
					1250,
					true);
			else
				ControlFactory::add_combobox($defs, $this, array('dialog_is_shown' => true),
					'live_urls_list_combo',
					'  Прямой эфир (URL)',
					$this->live_streaming_urls_list_idx,
					$this->get_live_streaming_urls_list(),
					1250,
					true);

			ControlFactory::add_vgap($defs, -10);

			if ($this->tv_archive_urls_list_idx == 'custom')
				ControlFactory::add_text_field($defs, $this, array('dialog_is_shown' => true),
					'custom_tv_archive_url_field',
					'  ТВ Архив (URL)',
					$this->custom_tv_archive_url,
					false,
					false,
					false,
					false,
					1250,
					true);
			else if ($this->tv_archive_urls_list_idx <> 'empty')
				ControlFactory::add_combobox($defs, $this, array('dialog_is_shown' => true),
					'archive_urls_list_combo',
					'  ТВ Архив (URL)',
					$this->tv_archive_urls_list_idx,
					$this->get_tv_archive_urls_list(),
					1250,
					true);
			else
			{
				ControlFactory::add_button($defs, $this, null, 'tv_archive_deactivate_btn', '  ТВ Архив (URL)', 'Деактивирован', 1250, false);
				ControlFactory::add_vgap($defs, -65);
				ControlFactory::add_smart_label($defs, null,  '<gap width=' . (1600 - 95) . '/><icon>' . PLUGIN_IMG_PATH . '/' . (($this->tv_archive_urls_list_idx <> 'empty')? 'on' : 'off') . '.png</icon>');
				ControlFactory::add_vgap($defs, -4);
			}

			ControlFactory::add_vgap($defs, 10);
			ControlFactory::add_combobox($defs, $this, array('dialog_is_shown' => true),
				'epg_timeshift_combo',
				'Сдвиг телепрограммы',
				$this->epg_timeshift_hours_idx,
				self::$epg_timeshift_ops,
				1250,
				true);
			ControlFactory::add_vgap($defs, 10);
			ControlFactory::add_combobox($defs, $this, array('dialog_is_shown' => true),
				'zoom_mode_list_combo',
				'Масштабирование',
				$this->zoom_presets_list_idx,
				self::$zoom_presets_ops,
				1250,
				true);

			if (get_platform_kind() <> 'android')
			{
				ControlFactory::add_vgap($defs, -10);
				ControlFactory::add_combobox($defs, $this, array('dialog_is_shown' => true),
					'deinterlacing_mode_list_combo',
					'Сглаживание',
					$this->deinterlacing_modes_list_idx,
					self::$deinterlacing_modes_ops,
					1250,
					true);
			}
			else
				ControlFactory::add_vgap($defs, 59);
		}
		else
		{
			ControlFactory::add_vgap($defs, -17);
			ControlFactory::add_label($defs, 'Название', (empty($this->custom_title)? $this->channel->get_title() : $this->custom_title));
			ControlFactory::add_vgap($defs, -18);
			ControlFactory::add_label(
				$defs,
				'Субканал',
				($this->subchannels_list_idx == 'auto')? 'Автоподбор: ' . $this->subchannels_list[$this->channel->get_def_subchannel_id()]['bcName'] . ' (' . $this->subchannels_list[$this->channel->get_def_subchannel_id()]['bcNumber'] . ')' : $this->subchannels_list[$this->subchannels_list_idx]['bcName'] . ' (' . $this->subchannels_list[$this->subchannels_list_idx]['bcNumber'] . ')');
			ControlFactory::add_vgap($defs, -18);
			ControlFactory::add_multiline_label($defs, '  Иконка (URL)', wordwrap($this->channel->get_icon_url(), self::TXT_SPLIT_LENGTH, "\n", true), 2);
			ControlFactory::add_vgap($defs, -18);
			$channel_epg_ids = $this->channel->get_epg_ids();//array_merge($this->channel->get_epg_ids(), array('rt' => preg_replace('/rt@/', '', $this->channel->get_epg_id())));
			$channel_epg_id = '';

			foreach($this->plugin->tv->get_epg_providers($plugin_cookies) as $id)
				if (!empty($channel_epg_ids[$id]))
				{
					$channel_epg_id = "$id@{$channel_epg_ids[$id]}";
					break;
				}

			if (preg_match('/^yandex@/', $channel_epg_id))
				if (!preg_match('/yandex@.+@\d+/', $channel_epg_id))
					$channel_epg_id = rtrim($channel_epg_id, '@') . "@{$this->location_info->yid}";

			ControlFactory::add_label($defs, '  Телегид (ID)', empty($this->custom_epg_id)? 'Автоподбор: ' . $channel_epg_id : (($this->custom_epg_id <> 'empty')? $this->custom_epg_id : 'Деактивирован'));
			ControlFactory::add_vgap($defs, -18);
			$live_url = str_replace('ts://', '', $this->plugin->tv->get_tv_playback_url($this->channel->get_id(), 0, RET_LIVE_TEMPLATE_URL));

			if (preg_match('/\/mdrm\/CH_.+\/manifest\.mpd/', $live_url))
				$live_url = preg_replace('/\?.*$/', '', $live_url);

			ControlFactory::add_multiline_label(
				$defs,
				'  Прямой эфир (URL)',
				implode("\n", array_slice(explode("\n", iconv('Windows-1251', 'UTF-8', wordwrap(iconv('UTF-8', 'Windows-1251', empty($this->custom_live_streaming_url)? 'Автоподбор: ' . preg_replace('/\?.*$/', '', $live_url) : $live_url), self::TXT_SPLIT_LENGTH, "\n", true))), 0, 2)), 3);
			ControlFactory::add_vgap($defs, -18);

			if (empty($this->custom_tv_archive_url))
				$archive_url = $this->plugin->tv->get_tv_playback_url($this->channel->get_id(), 0, RET_ARCHIVE_TEMPLATE_URL);
			else if ($this->custom_tv_archive_url <> 'empty')
				$archive_url = $this->plugin->tv->get_http_url($this->custom_tv_archive_url, null);
			else
				$archive_url = $this->custom_tv_archive_url;

			if (preg_match('/\/mdrm\/CH_.+\/manifest\.mpd/', $archive_url))
				if (extract(parse_url($archive_url)))
				{
					$archive_url = "$scheme://$host$path?";

					foreach(explode('&', $query) as $param)
						if (!preg_match('/token=/', $param))
							$archive_url .= "$param&";

					$archive_url = rtrim($archive_url, '?&');
				}

			ControlFactory::add_multiline_label(
				$defs,
				'  ТВ Архив (URL)',
				implode("\n", array_slice(explode("\n", iconv('Windows-1251', 'UTF-8', wordwrap((empty($this->custom_tv_archive_url)? iconv('UTF-8', 'Windows-1251', 'Автоподбор: '). $archive_url : (($this->custom_tv_archive_url <> 'empty')? $archive_url : iconv('UTF-8', 'Windows-1251', 'Деактивирован'))), self::TXT_SPLIT_LENGTH, "\n", true))), 0, 2)), 3);
			ControlFactory::add_vgap($defs, -18);
			ControlFactory::add_label($defs, 'Сдвиг телепрограммы', self::$epg_timeshift_ops[$this->epg_timeshift_hours_idx]);
			ControlFactory::add_vgap($defs, -18);
			$zoom_idx = is_null($this->plugin->user_data->zoom)? $this->plugin->tv->dune_zoom_preset : $this->plugin->user_data->zoom;
			$zoom_preset = isset(self::$zoom_presets_ops[$zoom_idx])? self::$zoom_presets_ops[$zoom_idx] : 'Специальный';
			ControlFactory::add_label($defs, 'Масштабирование', ($this->zoom_presets_list_idx == 'default')? 'Системное: ' . $zoom_preset : $zoom_preset);

			if (get_platform_kind() <> 'android')
			{
				ControlFactory::add_vgap($defs, -18);
				$deinterlacing_mode = self::$deinterlacing_modes_ops[is_null($this->plugin->user_data->deint)? $this->plugin->tv->dune_deint_mode : $this->plugin->user_data->deint];
				ControlFactory::add_label($defs, 'Сглаживание', ($this->deinterlacing_modes_list_idx == 'default')? 'Системное: ' . $deinterlacing_mode  : $deinterlacing_mode);
			}
			else
				ControlFactory::add_vgap($defs, 51);
		}

		ControlFactory::add_vgap($defs, 20);

		if ($add_params['dialog_mode'] == 'editor')
		{
			$hint_lines = explode('|', self::$editor_ctrls_hints[$add_params['selected_control']]);
			ControlFactory::add_smart_label($defs, null,  (empty($hint_lines[0])? '<gap width=450/>' : ('<gap width=380/><icon>' . PLUGIN_IMG_PATH . '/info.png</icon><gap width=30/>')) . '<text size=small color=' . DEF_LABEL_TEXT_COLOR_SILVER . '>' . (empty($hint_lines[0])? '' : $hint_lines[0]) . '</text>');
			ControlFactory::add_vgap($defs, -36);
			ControlFactory::add_smart_label($defs, null, '<gap width=450/><text size=small color=' . DEF_LABEL_TEXT_COLOR_SILVER . '>' . (empty($hint_lines[1])? '' : $hint_lines[1]) . '</text>');
			ControlFactory::add_vgap($defs, -36);
			ControlFactory::add_smart_label($defs, null, '<gap width=450/><text size=small color=' . DEF_LABEL_TEXT_COLOR_SILVER . '>' . (empty($hint_lines[2])? '' : $hint_lines[2]) . '</text>');
			ControlFactory::add_vgap($defs, -36);
			ControlFactory::add_smart_label($defs, null, '<gap width=450/><text size=small color=' . DEF_LABEL_TEXT_COLOR_SILVER . '>' . (empty($hint_lines[3])? '' : $hint_lines[3]) . '</text>');
			ControlFactory::add_vgap($defs, -159);
			ControlFactory::add_button($defs, $this, array('dialog_is_shown' => true), 'ch_editor_save_btn', null, 'Сохранить', 300);
			ControlFactory::add_button($defs, $this, array('dialog_is_shown' => true), (empty($add_params['post_action_id']))? 'ch_editor_change_mode_btn' : $add_params['post_action_id'], null, 'Отмена', 300);
		}
		else
		{
			ControlFactory::add_button($defs, $this, array('dialog_is_shown' => true), 'ch_editor_close_and_update_btn', null, 'Ok', 300);
			ControlFactory::add_button($defs, $this, array('dialog_is_shown' => true), 'ch_editor_change_mode_btn', null, 'Изменить', 300);
		}

		ControlFactory::add_vgap($defs, 14);

		return $defs;
	}

	public function handle_user_input(&$user_input, &$plugin_cookies)
	{
		static	$selected_idx;
		static	$most_idx;
		static	$add_params = array();
		static	$old_live_streaming_urls_list_idx;
		static	$old_tv_archive_urls_list_idx;
		static	$old_epg_timeshift_hours_idx;
		static	$old_icon_urls_list_idx;
		static	$old_custom_icon_url;

		$channel_id = MediaURL::decode($user_input->selected_media_url)->channel_id;

		if (isset($user_input->action_type))
		{
			if ($user_input->action_type == 'confirm')
			{
				$new_value = trim($user_input->{$user_input->control_id});

				switch ($user_input->control_id)
				{
					case 'title_field':
						$this->custom_title = $new_value;
						$selected_idx = 0;
						$add_params['title_mode'] = 'view';
						break;

					case 'subchannels_list_combo':
						$this->subchannels_list_idx = $new_value;
						$this->live_streaming_urls_list_idx = empty($this->custom_live_streaming_url)? 'auto' : array_search($this->custom_live_streaming_url, preg_replace('#\[.*\]\s*#', '', $this->get_live_streaming_urls_list()));
						$selected_idx = 1;
						break;

					case 'icon_urls_list_combo':
						$this->icon_urls_list_idx = $new_value;

						if ($new_value == 'custom')
							$this->custom_icon_url = '';

						$selected_idx = 2;
						break;

					case 'icon_url_field':
						$this->icon_urls_list_idx = empty($new_value)? $old_icon_urls_list_idx : $new_value;
						$this->custom_icon_url = empty($new_value)? null : $new_value;
						$selected_idx = 2;
						break;

					case 'epg_ids_list_combo':
						$this->epg_ids_list_idx = $new_value;

						if (($this->epg_ids_list_idx == 'custom') && ($this->custom_epg_id == 'empty'))
							$this->custom_epg_id = '';

						$selected_idx = 3;
						break;

					case 'custom_epg_id_field':
						$this->custom_epg_id = empty($new_value)? null : preg_replace('/\s/', '', $new_value); //is_numeric($new_value)? $new_value : null;

						if (!empty($new_value))
						{
							$err_msg = '';
							$epg_info = $this->plugin->epg->parse_epg_id($new_value);
							$service_name_valid = in_array($epg_info->parser_name, array_merge(array('rt'), $this->plugin->epg->get_parsers_list()));

							if (!empty($epg_info->parser_name) && $service_name_valid)
							{
								if (is_numeric($epg_info->channel_id) &&
									((($epg_info->parser_name == 'wink') && (strlen($epg_info->channel_id) >= 5)) ||
									(($epg_info->parser_name == 'vsetv') && (strlen($epg_info->channel_id) < 5))))
									$this->custom_epg_id = $new_value;
								else if (($epg_info->parser_name == 'yandex') && (empty($epg_info->region_id) || is_numeric($epg_info->region_id)))
									$this->custom_epg_id = $new_value;
								else
									$err_msg = 'Неверный идентификатор канала для EPG-сервиса "' . $epg_info->parser_name . '"!';
							}
							else
							{
								if (!$service_name_valid)
								{
									if (empty($epg_info->channel_id))
									{
										if (!empty($epg_info->parser_name))
										{
											if (is_numeric($epg_info->parser_name))
												$this->custom_epg_id = ((strlen($epg_info->parser_name) >= 5)? 'rt@' : 'vsetv@') . $epg_info->parser_name;
											else
												$err_msg = 'Неверный идентификатор EPG-сервиса!';
										}
										else
											$err_msg = 'Неверный идентификатор EPG-сервиса!';
									}
									else if (empty($epg_info->parser_name))
										$err_msg = 'Не удалось распознать EPG-сервис. Проверьте имя EPG-сервиса.';
									else
										$err_msg = 'Неподдерживаемый идентификатор EPG-сервиса "' . $epg_info->parser_name . '"!';
								}
							}
						}
						if (!empty($err_msg))
						{
							ControlFactoryExt::add_box($defs, 530, 1300);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=20/><icon>' . PLUGIN_IMG_PATH . '/info.png</icon>');
							ControlFactoryExt::add_vgap($defs, -69);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=110/><text size=' . PLUGIN_FONT_SMALL . '>Идентификатор EPG-сервиса состоит из мнемокода сервиса и строки</text>');
							ControlFactoryExt::add_vgap($defs, -34);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=110/><text size=' . PLUGIN_FONT_SMALL . '>идентификатора канала на этом сервисе, разделенных символом @.</text>');
							ControlFactoryExt::add_vgap($defs, -24);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=110/><text size=' . PLUGIN_FONT_SMALL . '>Синтаксис: service_name@channel_id[channel_url] [@region_id]</text>');
							ControlFactoryExt::add_vgap($defs, -24);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=110/><text size=' . PLUGIN_FONT_SMALL . '>Поддерживаемые сервисы:</text>');
							ControlFactoryExt::add_vgap($defs, -34);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=150/><text size=' . PLUGIN_FONT_SMALL . '>rt</text>');
							ControlFactoryExt::add_vgap($defs, -69);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=300/><text size=' . PLUGIN_FONT_SMALL . '>- телепрограмма с ресурсов Интерактивного ТВ от Ростелеком</text>');
							ControlFactoryExt::add_vgap($defs, -34);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=150/><text size=' . PLUGIN_FONT_SMALL . '>smartlabs</text>');
							ControlFactoryExt::add_vgap($defs, -69);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=300/><text size=' . PLUGIN_FONT_SMALL . '>- телепрограмма по ссылке для платформы Smartlabs</text>');
							ControlFactoryExt::add_vgap($defs, -34);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=150/><text size=' . PLUGIN_FONT_SMALL . '>yandex</text>');
							ControlFactoryExt::add_vgap($defs, -69);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=300/><text size=' . PLUGIN_FONT_SMALL . '>- телепрограмма с ресурса Яндекс.Телепрограмма</text>');
							ControlFactoryExt::add_vgap($defs, -34);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=150/><text size=' . PLUGIN_FONT_SMALL . '>vsetv</text>');
							ControlFactoryExt::add_vgap($defs, -69);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=300/><text size=' . PLUGIN_FONT_SMALL . '>- телепрограмма с сайта vsetv.сom</text>');
							ControlFactoryExt::add_vgap($defs, -24);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=110/><text size=' . PLUGIN_FONT_SMALL . '>Примеры правильных идентификаторов:</text>');
							ControlFactoryExt::add_vgap($defs, -34);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=150/><text size=' . PLUGIN_FONT_SMALL . '>rt@1000069 (rt@channel_id)</text>');
							ControlFactoryExt::add_vgap($defs, -34);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=150/><text size=' . PLUGIN_FONT_SMALL . '>smartlabs@http_ссылка_на_телепрограмму (smartlabs@channel_url)</text>');
							ControlFactoryExt::add_vgap($defs, -34);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=150/><text size=' . PLUGIN_FONT_SMALL . '>yandex@pervyy-16, yandex@pervyy-16@213 (yandex@channel_id [@region_id])</text>');
							ControlFactoryExt::add_vgap($defs, -34);
							ControlFactoryExt::add_smart_label($defs, null, '<gap width=150/><text size=' . PLUGIN_FONT_SMALL . '>vsetv@8 (vsetv@channel_id)</text>');
							ControlFactoryExt::add_vgap($defs, 40);
							ControlFactoryExt::add_close_dialog_button($button_defs, 'OK', 400);
							ControlFactoryExt::add_button_centered($defs, $button_defs, 1300);
							ControlFactoryExt::add_vgap($defs, 10);

							return
								ActionFactorySafe::show_dialog($err_msg, $defs, true, 1300);
						}

						$this->epg_ids_list_idx = empty($this->custom_epg_id)? 'auto' : $this->custom_epg_id;
						$selected_idx = 3;
						break;

					case 'live_urls_list_combo':
						$this->live_streaming_urls_list_idx = $new_value;
						$selected_idx = 4;
						break;

					case 'custom_live_streaming_url_field':
						if (empty($new_value))
							$this->live_streaming_urls_list_idx = $old_live_streaming_urls_list_idx;
						else
						{
							if ((stripos($new_value, 'udp://@') === false) && (stripos($new_value, 'http://') === false) && (stripos($new_value, 'https://') === false) && (stripos($new_value, 'dvb://') === false))
								$new_value = is_numeric(preg_replace('/\W/', '', $new_value))? 'udp://@' . $new_value : 'http://' . $new_value;

							$this->live_streaming_urls_list_idx = $new_value;
						}

						$this->custom_live_streaming_url = $new_value;
						$selected_idx = 4;
						break;

					case 'archive_urls_list_combo':
						$this->tv_archive_urls_list_idx = $new_value;

						if (($this->tv_archive_urls_list_idx == 'custom') && ($this->custom_tv_archive_url == 'empty'))
							$this->custom_tv_archive_url = '';

						$selected_idx = 5;
						break;

					case 'custom_tv_archive_url_field':
						if (empty($new_value))
							$this->tv_archive_urls_list_idx = $old_tv_archive_urls_list_idx;
						else
						{
							if ((strpos($new_value, 'http://') === false) && (strpos($new_value, 'https://') === false))
								$new_value = 'http://' . $new_value;

							$this->tv_archive_urls_list_idx = $new_value;
						}

						$this->custom_tv_archive_url = $new_value;
						$selected_idx = 5;
						break;

					case 'epg_timeshift_combo':
						$this->epg_timeshift_hours_idx = $new_value;
						$selected_idx = 6;
						break;

					case 'zoom_mode_list_combo':
						$this->zoom_presets_list_idx = $new_value;
						$selected_idx = 7;
						break;

					case 'deinterlacing_mode_list_combo':
						$this->deinterlacing_modes_list_idx = $new_value;
						$selected_idx = 8;
						break;
				}
			}
			else if ($user_input->action_type == 'apply')
			{
				switch ($user_input->control_id)
				{
					case 'epg_deactivate_btn':
						$this->epg_ids_list_idx = 'auto';
						break;

					case 'tv_archive_deactivate_btn':
						$this->tv_archive_urls_list_idx = 'auto';
						break;

					case 'do_closed_warning_dialog':
						$this->plugin->user_data->icon_url = null;
						$this->plugin->user_data->save();
						break;

					case 'ch_editor_save_btn':
						$this->need_refresh = true;
						$this->plugin->user_data->title = empty($this->custom_title)? null : $this->custom_title;
						$icon_urls_list = $this->get_icon_urls_list();

						if (($this->icon_urls_list_idx <> 'auto') && !empty($this->custom_icon_url) && isset($icon_urls_list[$this->custom_icon_url]))
						{
							if (strpos($this->custom_icon_url, ICONS_CACHE_PATH) === false)
							{
								$custom_icon_path = ICONS_CACHE_PATH . '/' . md5("{$this->channel->get_number()}_{$this->custom_icon_url}") . '.' . pathinfo($this->custom_icon_url, PATHINFO_EXTENSION);

								if (!file_exists($custom_icon_path))
								{
									$data = file_get_contents($this->custom_icon_url);
									$this->icon_urls_list_idx = preg_replace('/\?.*/', '', $custom_icon_path);

									if (($data === false) || (file_put_contents($this->icon_urls_list_idx, $data) === false))
									{
										$old_custom_icon_url = $this->custom_icon_url;
										$this->custom_icon_url = null;
										$this->icon_urls_list_idx = 'auto';
										ControlFactory::add_multiline_label($defs, null, "Не удалось скачать иконку по ссылке:\n" . wordwrap($old_custom_icon_url, 45, "\n", true) . "\n\nПопробуйте другую ссылку.", 5);
										ControlFactory::add_vgap($defs, 40);
										ControlFactory::add_close_dialog_and_apply_button($button_defs, $this, array('dialog_mode' => 'info'), 'do_closed_warning_dialog', 'Ok', 350);
										ControlFactoryExt::add_button_centered($defs, $button_defs, 900);
										ControlFactory::add_vgap($defs, 10);
										throw new DuneException(
											get_class($this).': Сan`t download the icon from url "' . $old_custom_icon_url . '"!', 0,
											ActionFactorySafe::show_dialog('ВНИМАНИЕ!', $defs, false, 900));
									}
								}
							}
						}

						$this->plugin->user_data->icon_url = ($this->icon_urls_list_idx == 'auto')? null : $this->icon_urls_list_idx;
						$this->plugin->user_data->epg_timeshift = empty($this->epg_timeshift_hours_idx)? null : $this->epg_timeshift_hours_idx;
						$this->plugin->user_data->subchannel_id = ($this->subchannels_list_idx == 'auto')? null : $this->subchannels_list_idx;
						$this->custom_live_streaming_url = (($this->live_streaming_urls_list_idx !== 'custom') && ($this->live_streaming_urls_list_idx <> 'auto'))? $this->live_streaming_urls_list_idx : null;
						$this->plugin->user_data->live_streaming_url = $this->custom_live_streaming_url;
						$this->custom_tv_archive_url = (($this->tv_archive_urls_list_idx !== 'custom') && ($this->tv_archive_urls_list_idx <> 'auto'))? $this->tv_archive_urls_list_idx : null;
						$this->plugin->user_data->tv_archive_url = $this->custom_tv_archive_url;
						$this->custom_epg_id = (($this->epg_ids_list_idx !== 'custom') && ($this->epg_ids_list_idx <> 'auto'))? $this->epg_ids_list_idx : null;
						$this->plugin->user_data->epg_id = $this->custom_epg_id;
						$this->plugin->user_data->zoom = ($this->zoom_presets_list_idx == 'default')? null : $this->zoom_presets_list_idx;
						$this->plugin->user_data->deint = ($this->deinterlacing_modes_list_idx == 'default')? null : $this->deinterlacing_modes_list_idx;
						$this->plugin->user_data->save();

						if ($this->channel->is_hd())
						{
							$this->channel->add_group(HomeTv::HDTV_CHANNELS_GROUP_ID);
							$this->plugin->tv->groups[HomeTv::HDTV_CHANNELS_GROUP_ID]['channels'][$channel_id] = $channel_id;
						}
						else
						{
							$this->channel->remove_group(HomeTv::HDTV_CHANNELS_GROUP_ID);
							unset($this->plugin->tv->groups[HomeTv::HDTV_CHANNELS_GROUP_ID]['channels'][$channel_id]);
						}

						$this->plugin->tv->channels->replace($this->channel);
						$this->plugin->epg->clear_ram_cache();
						$most_idx = 1;
						$selected_idx = 0;
						$add_params['dialog_mode'] = 'info';

					case 'ch_editor_close_and_update_btn':
						if ($this->need_refresh)
						{
							$this->plugin->tv->unload_channels();
							$range = $this->screen_handle->get_folder_range(MediaURL::decode($user_input->parent_media_url), 0, $plugin_cookies);
							$post_action = ActionFactorySafe::update_regular_folder($range, true, $user_input->sel_ndx);

							if (class_exists("PluginRowsFolderView") && class_exists('EpfsHandler'))
							{
								EpfsHandler::update_tv_epfs($plugin_cookies);

								return
									ActionFactorySafe::close_dialog_and_run(EpfsHandler::invalidate_folders(array(TvGroupsScreen::get_media_url_str(), $user_input->parent_media_url), $post_action));
							}

							return
								ActionFactorySafe::close_dialog_and_run(ActionFactorySafe::invalidate_folders(array(TvGroupsScreen::get_media_url_str(), $user_input->parent_media_url), $post_action));
						}

						return
							ActionFactorySafe::close_dialog_and_run();

					case 'title_mode_btn':
						$add_params['title_mode'] = ($add_params['title_mode'] == 'edit')? 'view' : 'edit';
						$selected_idx = 0;
						break;

					case 'ch_editor_change_mode_btn':
						$add_params['dialog_mode'] = ($add_params['dialog_mode'] == 'editor')? 'info' : 'editor';

						if (!empty($add_params['post_action_id']))
							return
								UserInputHandlerRegistry::create_action($this, $add_params['post_action_id'], $add_params);

					case 'do_show_dialog':
						if (isset($user_input->dialog_mode))
							$add_params['dialog_mode'] = $user_input->dialog_mode;

						$add_params = array_merge(
							$add_params,
							array(
								'title_mode' => 'view',
								'dialog_is_shown' => isset($user_input->dialog_is_shown)? $user_input->dialog_is_shown : false,
								'selected_control' => isset($user_input->selected_control)? $user_input->selected_control : (($add_params['dialog_mode'] == 'editor')? 'title_field' : 'ch_editor_close_and_update_btn'),
								'post_action_id' => isset($user_input->post_action_id)? $user_input->post_action_id : ''));

						$most_idx = ($add_params['dialog_mode'] == 'editor')? ((get_platform_kind() <> 'android')? 10 : 9) : 1;
						$selected_idx = 0;
						$this->initialize($channel_id, $add_params);
						$old_live_streaming_urls_list_idx = $this->live_streaming_urls_list_idx;
						$old_tv_archive_urls_list_idx = $this->tv_archive_urls_list_idx;
						$old_icon_urls_list_idx = $this->icon_urls_list_idx;
						$old_custom_icon_url = $this->custom_icon_url;
						$old_epg_timeshift_hours_idx = $this->channel->get_timeshift_hours();

						if (!$add_params['dialog_is_shown'])
						{
							$add_params['dialog_is_shown'] = true;
							$this->need_refresh = false;
							return
								ActionFactorySafe::show_dialog(
									null,
									$this->get_dialog_controls_defs($add_params, $plugin_cookies),
									true,
									1600,
									array
									(
										'dialog_params' =>
											array
											(
												'frame_style' => ((isset($user_input->dialog_frame_style))? $user_input->dialog_frame_style : DIALOG_FRAME_STYLE_DEFAULT),
											),
										'actions' =>
											array
											(
												GUI_EVENT_KEY_UP => UserInputHandlerRegistry::create_action($this, 'do_key_up'),
												GUI_EVENT_KEY_DOWN => UserInputHandlerRegistry::create_action($this, 'do_key_down'),
												GUI_EVENT_KEY_LEFT => UserInputHandlerRegistry::create_action($this, 'do_key_left'),
												GUI_EVENT_KEY_RIGHT => UserInputHandlerRegistry::create_action($this, 'do_key_right'),
												GUI_EVENT_KEY_RETURN => UserInputHandlerRegistry::create_action($this, 'ch_editor_close_and_update_btn', array('action_type' => 'apply')),
											),
									)
							);
						}
				}
			}
		}
		else
		{
			$add_params['selected_control'] = $user_input->selected_control_id;

			switch ($user_input->control_id)
			{
				case 'refresh':
					return
						ActionFactorySafe::reset_controls($this->get_dialog_controls_defs($add_params, $plugin_cookies));

				case 'do_key_up':
					$selected_idx -= 1;

					if ($selected_idx < 0)
						$selected_idx = 0;

					break;

				case 'do_key_down':
					$selected_idx += 1;

					if ($selected_idx > $most_idx)
						$selected_idx = $most_idx;

					break;

				case 'do_key_left':
					$selected_idx = 0;
					break;

				case 'do_key_right':
					$selected_idx = $most_idx - ((strpos('do_edit_do_show_do_close', substr($add_params['selected_control'], 0, 6)) === false)? 1 : 0);
					break;
			}
		}

		if ($selected_idx <> 0)
			$add_params['title_mode'] = 'view';

		return
			ActionFactorySafe::reset_controls(
				$this->get_dialog_controls_defs($add_params, $plugin_cookies),
				ActionFactorySafe::change_behaviour(
					array
					(
						GUI_EVENT_KEY_UP => UserInputHandlerRegistry::create_action($this, 'do_key_up'),
						GUI_EVENT_KEY_DOWN => UserInputHandlerRegistry::create_action($this, 'do_key_down'),
						GUI_EVENT_KEY_LEFT => UserInputHandlerRegistry::create_action($this, 'do_key_left'),
						GUI_EVENT_KEY_RIGHT => UserInputHandlerRegistry::create_action($this, 'do_key_right'),
						GUI_EVENT_KEY_RETURN => UserInputHandlerRegistry::create_action($this, 'ch_editor_close_and_update_btn', array('action_type' => 'apply')),
					),
					null,
					UserInputHandlerRegistry::create_action($this, 'refresh')), $selected_idx);
	}

	public function show_info(&$screen_handle)
	{
		$this->screen_handle = $screen_handle;

		return
			UserInputHandlerRegistry::create_action($this, 'do_show_dialog', array('dialog_mode' => 'info', 'action_type' => 'apply'));
	}

	public function show_editor(&$screen_handle)
	{
		$this->screen_handle = $screen_handle;

		return
			UserInputHandlerRegistry::create_action($this, 'do_show_dialog', array('dialog_mode' => 'editor', 'post_action_id' => 'ch_editor_close_and_update_btn', 'action_type' => 'apply'));
	}
}

?>
