var app = {

	doUrl: location.href.substring(0, location.href.indexOf(location.pathname)) + '/cgi-bin/do',

	options: null,

	ajaxGet: function(url, data, responseHandler, errorHandler)
	{
		var rh;
		if (typeof responseHandler === 'function') rh = function(data) { responseHandler(data); };
		else rh = $.proxy(this.ajaxResponseHandler, this);

		$.get(url, data, rh);
	},
	
	rControl: function(keyCode)
	{
		this.ajaxGet(this.doUrl,
			{
				cmd: 'ir_code',
				ir_code: keyCode
			});
	}
}

var rtext = {

	$duneText: null,

	init: function()
	{
		this.$duneText = $('#dune_text');

		$('#get_dune').on('click', $.proxy(this.textFromDune, this));
		$('#send_dune').on('click', $.proxy(this.textToDune, this));
	},

	textFromDune: function()
	{
		app.ajaxGet(app.doUrl,
			{
				cmd: 'get_text'
			},

			$.proxy(this.processGetTextResponse, this));
	},

	processGetTextResponse: function(data)
	{
		var params = data.getElementsByTagName('param');
		for (var i = 0; i < params.length; ++i)
		{
			var pName = params[i].getAttribute('name');
			var pVal = params[i].getAttribute('value');

			if (pName === 'text')
			{
				this.$duneText.val(pVal);
				break;
			}
			else if (pName === 'error_description')
			{
				alert("Текстовое поле не активно");				
				break;
			}
		}
	},

	textToDune: function()
	{
		app.ajaxGet(app.doUrl,
			{
				cmd: 'set_text',
				text: this.$duneText.val()
			});
	}
};

$(function()
{
	rtext.init()
});
